/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.handlers.merge;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.transition.common.handlers.merge.CategoryFilter;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.merge.Messages;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ManyToOneCategoryFilter
extends CategoryFilter {
    public ManyToOneCategoryFilter(IContext context) {
        super(context, Messages.ManyToOneCategoryFilter, Messages.ManyToOneCategoryFilter_Description);
        this.setCategorySet("category.business");
        this.setInFocusMode(false);
        this.setActive(true);
        this.setVisible(true);
    }

    public boolean covers(IDifference difference) {
        if (difference instanceof IElementPresence) {
            Object current = (IElementPresence)difference;
            while (current != null) {
                EObject container = current.getElementMatch().get(Role.REFERENCE);
                if (container == null) break;
                ITraceabilityHandler sourceHandler = (ITraceabilityHandler)this.context.get((Object)"TSMH");
                ITraceabilityHandler targetHandler = (ITraceabilityHandler)this.context.get((Object)"TTMH");
                HashSet nbElements = new HashSet();
                Collection sources = sourceHandler.retrieveSourceElements(container, this.context);
                for (EObject source : sources) {
                    for (EObject target : targetHandler.retrieveTracedElements(source, this.context)) {
                        nbElements.addAll(targetHandler.retrieveSourceElements(target, this.context));
                    }
                }
                if (nbElements.size() > 1) {
                    return true;
                }
                IMatch containerMatch = current.getComparison().getMapping().getMatchFor(container.eContainer(), Role.REFERENCE);
                current = containerMatch != null ? containerMatch.getElementPresenceDifference() : null;
            }
        }
        return false;
    }
}

