/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.handlers.traceability.config;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.LevelBasedTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ExtendedTraceabilityConfiguration;
import org.polarsys.capella.core.transition.system.handlers.traceability.RealizationLinkTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.ReconciliationTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.SIDTraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MergeSourceConfiguration
extends ExtendedTraceabilityConfiguration {
    protected String getExtensionIdentifier(IContext context) {
        return "sourceTraceabilityConfiguration";
    }

    protected void initHandlers(IContext fContext) {
        this.addHandler(fContext, (ITraceabilityHandler)new SourceReconciliationTraceabilityHandler(this.getIdentifier(fContext)));
        this.addHandler(fContext, (ITraceabilityHandler)new SourceSIDTraceabilityHandler(this.getIdentifier(fContext)));
    }

    public boolean useHandlerForAttachment(EObject source, EObject target, ITraceabilityHandler handler, IContext context) {
        if (handler instanceof ReconciliationTraceabilityHandler) {
            return false;
        }
        return super.useHandlerForAttachment(source, target, handler, context);
    }

    public boolean useHandlerForTracedElements(EObject source, ITraceabilityHandler handler, IContext context) {
        boolean result = super.useHandlerForTracedElements(source, handler, context);
        if (result && handler instanceof RealizationLinkTraceabilityHandler) {
            if (source instanceof SystemEngineering) {
                result = false;
            } else if (source instanceof BlockArchitecture) {
                result = false;
            }
        }
        return result;
    }

    public boolean useHandlerForSourceElements(EObject source, ITraceabilityHandler handler, IContext context) {
        boolean result = super.useHandlerForSourceElements(source, handler, context);
        if (result && handler instanceof RealizationLinkTraceabilityHandler) {
            if (source instanceof SystemEngineering) {
                result = false;
            } else if (source instanceof BlockArchitecture) {
                result = false;
            }
        }
        return result;
    }

    protected class SourceReconciliationTraceabilityHandler
    extends ReconciliationTraceabilityHandler {
        public SourceReconciliationTraceabilityHandler(String identifier) {
            super(identifier);
        }

        @Override
        protected void initializeBlockArchitecture(BlockArchitecture source, BlockArchitecture target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            super.initializeBlockArchitecture(source, target, context, map);
            Component sourceComponent = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)source);
            Component targetComponent = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)target);
            if (sourceComponent != null && targetComponent != null && !map.contains((Object)sourceComponent) && !map.contains((Object)targetComponent)) {
                this.addMapping((MappingTraceability)map, (EObject)sourceComponent, (EObject)targetComponent, context);
            }
        }

        protected void initializeRootMappings(IContext context) {
            super.initializeRootMappings(context);
            EObject source = (EObject)context.get((Object)"_Tr_S_R");
            EObject target = (EObject)context.get((Object)"_Tr_T_R");
            this.addMappings(source, target, context);
        }
    }

    protected class SourceSIDTraceabilityHandler
    extends SIDTraceabilityHandler {
        public SourceSIDTraceabilityHandler(String identifier) {
            super(identifier);
        }

        protected void initializeRootMappings(IContext context) {
            super.initializeRootMappings(context);
            EObject source = (EObject)context.get((Object)"_Tr_S_R");
            EObject target = (EObject)context.get((Object)"_Tr_T_R");
            this.initializeMappings(source, target, context);
        }
    }
}

