/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractData {
    public static final Object[] NO_CHILD = new Object[0];
    public static final Object UNDEFINED_CONTEXT = new Object();
    private Object _context;
    private Runnable _notifiedForValidElementsChanges;
    Collection<Object> _rootElements;
    Collection<Object> _validElements;

    protected AbstractData(Collection<? extends Object> displayedElements, Object context) {
        this._context = context;
        this._rootElements = this.initializeRootElementCollection();
        this._validElements = this.initializeValidElementCollection(displayedElements);
        for (Object object : displayedElements) {
            this.addElement(object);
        }
    }

    public void addAllElements(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.addElement(element);
            this.addValidElement(element);
            ++n2;
        }
    }

    public void addElement(Object element) {
        this._rootElements.add(element);
    }

    protected void addValidElement(Object element) {
        this._validElements.add(element);
    }

    protected void clearData() {
        this._rootElements.clear();
    }

    public abstract Object[] getChildren(Object var1);

    public Object getContext() {
        return this._context;
    }

    public Object[] getElements() {
        return this._rootElements.toArray(new Object[this._rootElements.size()]);
    }

    public Runnable getNotifiedForValidElementsChanges() {
        return this._notifiedForValidElementsChanges;
    }

    public abstract Object getParent(Object var1);

    public List<Object> getValidElements() {
        return new ArrayList<Object>(this._validElements);
    }

    protected Collection<Object> initializeRootElementCollection() {
        return new HashSet<Object>(0);
    }

    protected Collection<Object> initializeValidElementCollection(Collection<? extends Object> displayedElements) {
        return new HashSet<Object>(displayedElements);
    }

    public boolean isValid(Object elment) {
        return this._validElements.contains(elment);
    }

    protected void notifyValidElementsChanges() {
        if (this._notifiedForValidElementsChanges != null) {
            this._notifiedForValidElementsChanges.run();
        }
    }

    public void removeAllElements(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.removeElement(element);
            this.removeValidElement(element);
            ++n2;
        }
    }

    public void removeElement(Object element) {
        this._rootElements.remove(element);
    }

    public void removeValidElement(Object element) {
        this._validElements.remove(element);
    }

    public void setNotifiedForValidElementsChanges(Runnable notifiedForValidElementsChanges) {
        this._notifiedForValidElementsChanges = notifiedForValidElementsChanges;
    }
}

