/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.diagram.helpers;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.core.diagram.helpers.Messages;

public class DiagramHelper {
    private static DiagramHelper instance;

    protected DiagramHelper() {
    }

    public static DiagramHelper getService() {
        if (instance == null) {
            instance = new DiagramHelper();
        }
        return instance;
    }

    public RepresentationDescription getDescription(DRepresentation representation) {
        return DialectManager.INSTANCE.getDescription(representation);
    }

    public boolean isA(DRepresentation diagram, String descriptionId) {
        if (diagram != null) {
            RepresentationDescription description = this.getDescription(diagram);
            return this.isA(description, descriptionId);
        }
        return false;
    }

    public boolean isA(RepresentationDescription description, String diagramDescriptionId) {
        if (description != null) {
            if (diagramDescriptionId == null) {
                return true;
            }
            return diagramDescriptionId.equals(description.getName());
        }
        return false;
    }

    public boolean isArchitectureBlank(DRepresentation diagram) {
        return this.hasKind(diagram, "Architecture Blank") || this.hasKind(diagram, "Entity Blank");
    }

    public boolean isBreakdown(DRepresentation diagram) {
        return this.hasKind(diagram, "Breakdown");
    }

    public boolean hasKind(DRepresentation diagram, String diagramDescriptionId) {
        if (diagram != null) {
            RepresentationDescription description = this.getDescription(diagram);
            return this.hasKind(description, diagramDescriptionId);
        }
        return false;
    }

    private boolean hasKind(RepresentationDescription description, String diagramDescriptionId) {
        if (description != null) {
            if (diagramDescriptionId == null) {
                return true;
            }
            return description.getName().contains(diagramDescriptionId);
        }
        return false;
    }

    public DDiagram getDiagramContainer(EObject current) {
        if (current instanceof DDiagram) {
            return (DDiagram)current;
        }
        return (DDiagram)EcoreUtil2.getFirstContainer((EObject)current, (EClass)DiagramPackage.Literals.DDIAGRAM);
    }

    public RepresentationDescription getDescription(Session session, String descriptionId) {
        Collection viewpoints = session.getSelectedViewpoints(true);
        for (Viewpoint viewpoint : viewpoints) {
            for (RepresentationDescription description : viewpoint.getOwnedRepresentations()) {
                if (!descriptionId.equals(description.getName())) continue;
                return description;
            }
        }
        return null;
    }

    public Session getSession(DRepresentation diagram) {
        if (diagram instanceof DSemanticDecorator) {
            EObject target = ((DSemanticDecorator)diagram).getTarget();
            if (target == null) {
                return null;
            }
            return SessionManager.INSTANCE.getSession(target);
        }
        return null;
    }

    public DRepresentation createDRepresentation(String name, EObject semantic, RepresentationDescription description, Session session, IProgressMonitor monitor) {
        return DialectManager.INSTANCE.createRepresentation(name, semantic, description, session, monitor);
    }

    public DRepresentation getRepresentation(DSemanticDecorator decorator) {
        if (decorator instanceof DRepresentation) {
            return (DRepresentation)decorator;
        }
        return (DRepresentation)EcoreUtil2.getFirstContainer((EObject)decorator, (EClass)ViewpointPackage.Literals.DREPRESENTATION);
    }

    public String getPackageName(DRepresentationDescriptor descriptor) {
        String name = null;
        DAnnotation annot = DAnnotationHelper.getAnnotation("https://www.polarsys.org/capella/dannotation/package", (DModelElement)descriptor, false);
        if (annot != null) {
            name = (String)annot.getDetails().get((Object)"name");
        }
        return name;
    }

    public Command createSetPackageNameCommand(TransactionalEditingDomain domain, final DRepresentationDescriptor descriptor, final String name) {
        RecordingCommand command = null;
        final DAnnotation annot = DAnnotationHelper.getAnnotation("https://www.polarsys.org/capella/dannotation/package", (DModelElement)descriptor, false);
        if (name != null) {
            String currentValue = null;
            if (annot != null) {
                currentValue = (String)annot.getDetails().get((Object)"name");
            }
            if (currentValue == null || !currentValue.equals(name)) {
                command = new RecordingCommand(domain){

                    public void doExecute() {
                        if (annot != null) {
                            SiriusUtil.delete((EObject)annot);
                        }
                        DAnnotation annot2 = DAnnotationHelper.getAnnotation("https://www.polarsys.org/capella/dannotation/package", (DModelElement)descriptor, true);
                        annot2.getDetails().put((Object)"name", (Object)name);
                    }
                };
                command.setLabel(Messages.DiagramHelper_0);
            }
        } else if (annot != null) {
            command = new RecordingCommand(domain){

                protected void doExecute() {
                    SiriusUtil.delete((EObject)annot);
                }
            };
            command.setLabel(Messages.DiagramHelper_1);
        }
        return command;
    }
}

