/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageMonitoringLogger;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.shared.id.handler.IdManager;

public class NewRepresentationAction
extends BaseSelectionListenerAction {
    private EObject selectedEObject;
    protected RepresentationDescription description;
    protected Session session;
    protected boolean forceDefaultName;
    protected boolean openRepresentation;
    private boolean isCanceled;

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session) {
        this(description, selectedEObject, session, false, true);
    }

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session, boolean forceDefaultName, boolean openRepresentation) {
        super(description.getName());
        String label = description.getLabel();
        if (label != null && label.length() > 1) {
            this.setText(label);
        }
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = description instanceof CrossTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/CrossTableDescription.gif") : (description instanceof EditionTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/DTable.gif") : (description instanceof SequenceDiagramDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.diagram.sequence.edit", (String)"/icons/full/obj16/TSequenceDiagram.gif") : AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.diagram.ui", (String)"/icons/full/obj16/DDiagram.gif")));
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.setImageDescriptor(imageDescriptor);
        this.selectedEObject = selectedEObject;
        this.description = description;
        this.session = session;
        this.forceDefaultName = forceDefaultName;
        this.openRepresentation = openRepresentation;
    }

    public void run() {
        String defaultName = this.computeDefaultName(this.selectedEObject, this.description);
        if (!this.forceDefaultName) {
            String label = this.description.getLabel();
            if (label == null || label.isEmpty()) {
                label = this.description.getName();
            }
            String dialogTitle = "New " + label;
            String dialogMessage = "Name:";
            Shell activeShell = Display.getDefault().getActiveShell();
            InputDialog representationNameDlg = new InputDialog(activeShell, dialogTitle, dialogMessage, defaultName, null);
            boolean bl = this.isCanceled = 1 == representationNameDlg.open();
            if (!this.isCanceled) {
                defaultName = representationNameDlg.getValue();
            } else {
                return;
            }
        }
        NewRepresentationCommand command = new NewRepresentationCommand(defaultName, this.selectedEObject, this.description, this.session);
        TransactionHelper.getExecutionManager((Session)this.session).execute((ICommand)command);
        if (command.getRepresentation() != null) {
            SessionManager.INSTANCE.notifyRepresentationCreated(this.session);
            if (this.openRepresentation) {
                DialectUIManager.INSTANCE.openEditor(this.session, command.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected String computeDefaultName(EObject eObject, RepresentationDescription repDescription) {
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)eObject);
        String newName = "New ";
        newName = !StringUtil.isEmpty((String)repDescription.getLabel()) ? String.valueOf(newName) + repDescription.getLabel() : String.valueOf(newName) + repDescription.getName();
        String titleExpression = repDescription.getTitleExpression();
        if (!StringUtil.isEmpty((String)titleExpression)) {
            try {
                newName = interpreter.evaluateString(eObject, titleExpression);
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
            }
        }
        return newName;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    private class NewRepresentationCommand
    extends AbstractReadWriteCommand {
        private String newName;
        private DRepresentation representation;
        private EObject eObject;
        private RepresentationDescription repDescription;
        private Session currentSession;

        public NewRepresentationCommand(String newName, EObject eObject, RepresentationDescription repDescription, Session session) {
            this.newName = newName;
            this.eObject = eObject;
            this.repDescription = repDescription;
            this.currentSession = session;
        }

        public void commandInterrupted() {
            this.commandRolledBack();
        }

        public void commandRolledBack() {
            this.representation = null;
        }

        public DRepresentation getRepresentation() {
            return this.representation;
        }

        public void run() {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (NewRepresentationAction.this.selectedEObject instanceof Scenario) {
                Scenario scenario = (Scenario)NewRepresentationAction.this.selectedEObject;
                scenario.setName(this.newName);
            }
            String eventName = "Create Representation";
            String eventContext = this.repDescription.getName();
            String addendum = IdManager.getInstance().getId(this.eObject);
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.NONE, addendum);
            this.representation = DialectManager.INSTANCE.createRepresentation(this.newName, this.eObject, this.repDescription, this.currentSession, (IProgressMonitor)monitor);
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.OK, addendum);
        }
    }
}

