/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.commands;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.projection.commands.ESToISCommand;
import org.polarsys.capella.core.projection.commands.Messages;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.scenario.FS2ESTransform;

public class FSToESCommand
extends ESToISCommand {
    public FSToESCommand(Collection<EObject> rootElements_p) {
        super(rootElements_p);
    }

    public FSToESCommand(Collection<EObject> rootElements_p, IProgressMonitor progressMonitor_p) {
        super(rootElements_p, progressMonitor_p);
    }

    @Override
    public String getName() {
        if (this.rootElements != null && this.rootElements.size() > 0) {
            EObject element = (EObject)this.rootElements.iterator().next();
            if (TransitionHelper.getService().isFS2ESForOASATransitionAvailable(element)) {
                return Messages.transitionFS2ES_OASA_label;
            }
            if (TransitionHelper.getService().isFS2ESForSALAPATransitionAvailable(element)) {
                return Messages.transitionFS2ES_SALAPA_label;
            }
        }
        return Messages.transitionFS2ES_label;
    }

    @Override
    protected AbstractTransform getTransformation(EObject element_p) {
        return new FS2ESTransform();
    }

    @Override
    protected boolean isScenarioValid(Scenario scenario_p) {
        return TransitionHelper.getService().isFS2ESTransitionAvailable((EObject)scenario_p);
    }
}

