/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.core.properties.sections.GeneralizableElementSection;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.properties.controllers.AllocatedFunctionsController;
import org.polarsys.capella.core.data.cs.properties.controllers.ImplementedInterfacesController;
import org.polarsys.capella.core.data.cs.properties.controllers.UsedInterfacesController;
import org.polarsys.capella.core.data.cs.properties.sections.Messages;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;

public abstract class ComponentSection
extends GeneralizableElementSection {
    private boolean _showImplementedInterfaces;
    private boolean _showUsedInterfaces;
    private boolean _showAllocatedFunctions;
    private MultipleSemanticField _implementedInterfaces;
    private MultipleSemanticField _usedInterfaces;
    protected MultipleSemanticField _allocatedFunctions;

    public ComponentSection() {
        this(true, true, true, true, true);
    }

    public ComponentSection(boolean showImplementedInterfaces, boolean showUsedInterfaces, boolean showAllocatedFunctions, boolean showSuperTypes, boolean showIsAbstract) {
        super(showSuperTypes, showIsAbstract);
        this._showImplementedInterfaces = showImplementedInterfaces;
        this._showUsedInterfaces = showUsedInterfaces;
        this._showAllocatedFunctions = showAllocatedFunctions;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        if (this._showImplementedInterfaces) {
            this._implementedInterfaces = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.ComponentSection_ImplementedInterfaces_Label, this.getWidgetFactory(), (IMultipleSemanticFieldController)new ImplementedInterfacesController());
            this._implementedInterfaces.setDisplayedInWizard(displayedInWizard);
        }
        if (this._showUsedInterfaces) {
            this._usedInterfaces = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.ComponentSection_UsedInterfaces_Label, this.getWidgetFactory(), (IMultipleSemanticFieldController)new UsedInterfacesController());
            this._usedInterfaces.setDisplayedInWizard(displayedInWizard);
        }
        if (this._showAllocatedFunctions) {
            this._allocatedFunctions = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.ComponentSection_AllocatedFunctions_Label, this.getWidgetFactory(), (IMultipleSemanticFieldController)new AllocatedFunctionsController());
            this._allocatedFunctions.setDisplayedInWizard(displayedInWizard);
        }
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        if (this._implementedInterfaces != null) {
            this._implementedInterfaces.loadData(capellaElement, (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_INTERFACE_IMPLEMENTATIONS);
        }
        if (this._usedInterfaces != null) {
            this._usedInterfaces.loadData(capellaElement, (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_INTERFACE_USES);
        }
        if (this._allocatedFunctions != null) {
            this._allocatedFunctions.loadData(capellaElement, (EStructuralFeature)FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
        }
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this._allocatedFunctions);
        fields.add((AbstractSemanticField)this._implementedInterfaces);
        fields.add((AbstractSemanticField)this._usedInterfaces);
        return fields;
    }
}

