/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.activities;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.handlers.attributes.AttributesHandlerHelper;
import org.polarsys.capella.common.re.handlers.location.LocationHandlerHelper;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.merge.ExtendedComparison;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class AttachmentActivity
extends AbstractActivity {
    public static final String ID = AttachmentActivity.class.getCanonicalName();

    protected IStatus _run(ActivityParameters activityParams) {
        IContext context = this.getContext(activityParams);
        CatalogElement sourceElement = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
        CatalogElement targetElement = ReplicableElementHandlerHelper.getInstance(context).getTarget(context);
        Collection sourceAddedElements = ContextScopeHandlerHelper.getInstance((IContext)context).getCollection("capella.re.SOURCE__ADDED_ELEMENTS", context);
        for (EObject object : sourceAddedElements) {
            if (!(object instanceof CatalogElementLink)) continue;
            this.attachContainment(context, (CatalogElementLink)object, true, sourceElement);
        }
        Collection targetAddedElements = ContextScopeHandlerHelper.getInstance((IContext)context).getCollection("capella.re.TARGET__ADDED_ELEMENTS", context);
        for (EObject object : targetAddedElements) {
            if (!(object instanceof CatalogElementLink)) continue;
            this.attachContainment(context, (CatalogElementLink)object, false, targetElement);
            this.updateElement(context, (CatalogElementLink)object, targetElement);
        }
        String value = (String)context.get((Object)"COMMAND__CURRENT_VALUE");
        if ("COMMAND__UPDATE_DEFINITION_REPLICA_FROM_REPLICA".equals(value) || "COMMAND__UPDATE_CURRENT_REPLICA_FROM_REPLICA".equals(value) || "COMMAND__CREATE_REPLICABLE_ELEMENT".equals(value)) {
            for (CatalogElementLink link : ReplicableElementHandlerHelper.getInstance(context).getElementsLinks(targetElement)) {
                this.storeUnsynchronizedFeatures(context, (EObject)link, (EObject)link, targetElement);
            }
            if ("COMMAND__UPDATE_DEFINITION_REPLICA_FROM_REPLICA".equals(value)) {
                for (CatalogElementLink link : ReplicableElementHandlerHelper.getInstance(context).getElementsLinks(sourceElement)) {
                    this.storeUnsynchronizedFeatures(context, (EObject)link.getOrigin(), (EObject)link, targetElement);
                }
            }
        } else if ("COMMAND__CREATE_A_REPLICA_FROM_REPLICABLE".equals(value) || "COMMAND__UPDATE_A_REPLICA_FROM_REPLICABLE".equals(value)) {
            for (CatalogElementLink link : ReplicableElementHandlerHelper.getInstance(context).getElementsLinks(targetElement)) {
                this.storeUnsynchronizedFeatures(context, (EObject)link, (EObject)link.getOrigin(), targetElement);
            }
        }
        for (EObject custom : AttributesHandlerHelper.getInstance(context).getCustomNameElements(context)) {
            if (!(custom instanceof CatalogElement)) continue;
            EObject target = custom;
            EStructuralFeature feature = AttributesHandlerHelper.getInstance(context).getSuffixableFeature(target, context);
            if (feature == null) continue;
            target.eSet(feature, (Object)AttributesHandlerHelper.getInstance(context).getCustomName(custom, context));
        }
        return Status.OK_STATUS;
    }

    protected void updateElement(IContext context, CatalogElementLink link, CatalogElement targetElement) {
        EObject target = link.getTarget();
        if (target != null && target instanceof CatalogElement) {
            CatalogElement element = (CatalogElement)target;
            if (link.getSource().getKind() != CatalogElementKind.RPL && element.getKind() == CatalogElementKind.RPL) {
                element.setKind(CatalogElementKind.REC_RPL);
            }
        }
    }

    protected void storeUnsynchronizedFeatures(IContext context, EObject link1, EObject linkSuffixable, CatalogElement target1) {
        if (link1 instanceof CatalogElementLink) {
            CatalogElementLink link = (CatalogElementLink)link1;
            CatalogElementLink suffixLink = (CatalogElementLink)linkSuffixable;
            if (linkSuffixable == null) {
                return;
            }
            EObject target = ((CatalogElementLink)linkSuffixable).getTarget();
            if (target != null) {
                if (link1 != linkSuffixable) {
                    for (String feature : new ArrayList(link.getUnsynchronizedFeatures())) {
                        if (suffixLink.getUnsynchronizedFeatures().contains((Object)feature)) continue;
                        link.getUnsynchronizedFeatures().remove((Object)feature);
                    }
                    for (String feature : suffixLink.getUnsynchronizedFeatures()) {
                        if (link.getUnsynchronizedFeatures().contains((Object)feature)) continue;
                        link.getUnsynchronizedFeatures().add((Object)feature);
                    }
                }
                if (AttributesHandlerHelper.getInstance(context).isSuffixable(target, context)) {
                    if (!link.isSuffixed()) {
                        link.setSuffixed(true);
                    }
                } else if (link.isSuffixed()) {
                    link.setSuffixed(false);
                }
            }
        }
    }

    public void attachContainment(IContext context, CatalogElementLink link, boolean isSource, CatalogElement element) {
        if (link == null || link.getTarget() == null) {
            return;
        }
        if (ContextScopeHandlerHelper.getInstance((IContext)context).contains("capella.re.UNMERGEABLE_ELEMENTS", link.getTarget(), context)) {
            return;
        }
        if (link.getTarget() != null && link.getTarget().eContainer() != null) {
            return;
        }
        Role destinationRole = isSource ? Role.REFERENCE : Role.TARGET;
        Role oppositeRole = !isSource ? Role.REFERENCE : Role.TARGET;
        ExtendedComparison comparison = (ExtendedComparison)context.get((Object)"MERGE_COMPARISON");
        EObject targetElement = link.getTarget();
        IMatch match = comparison.getMapping().getMatchFor(targetElement, destinationRole);
        if (match == null) {
            return;
        }
        EObject source = match.get(oppositeRole);
        EObject target = match.get(destinationRole);
        CatalogElementLink oppositeLink = ReplicableElementHandlerHelper.getInstance(context).getOppositeLink(link, context);
        EObject location = LocationHandlerHelper.getInstance(context).getCurrentLocation(link, context);
        if (location == null && (location = LocationHandlerHelper.getInstance(context).getLocation(link, oppositeLink, context)) == null) {
            location = LocationHandlerHelper.getInstance(context).getDefaultLocation(link, oppositeLink, context);
        }
        if (location != null && location instanceof CatalogElementLink) {
            IMatch match2 = comparison.getMapping().getMatchFor(((CatalogElementLink)location).getTarget(), oppositeRole);
            if (match2 == null) {
                match2 = comparison.getMapping().getMatchFor(((CatalogElementLink)location).getTarget(), destinationRole);
            }
            if (match2 != null) {
                location = match2.get(destinationRole);
            }
        }
        if (location != null) {
            EStructuralFeature feature = LocationHandlerHelper.getInstance(context).getFeature(source, target, location, context);
            this.attachElement(context, target, location, feature);
        } else {
            LogHelper.getInstance().debug(NLS.bind((String)"Element ''{0}'' has not been attached.", (Object)LogHelper.getInstance().getText((Object)target)), Messages.Activity_Transformation);
        }
    }

    protected boolean attachElement(IContext context, EObject source, EObject container, EStructuralFeature feature) {
        if (container != null && feature != null && AttachmentHelper.getInstance((IContext)context).isApplicable(container.eClass(), feature)) {
            AttachmentHelper.getInstance((IContext)context).attachElementByReference(container, source, (EReference)feature);
            return true;
        }
        return false;
    }
}

