/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.Collection;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementSelectionDialog<T>
extends MessageDialog {
    protected final Collection<? extends EObject> _candidates;
    protected ModelSubsetViewer _viewer;

    public AbstractElementSelectionDialog(Shell parentShell_p, String message_p, Collection<? extends EObject> proposed_p) {
        super(parentShell_p, CorePatternsPlugin.getDefault().getLabel(), null, message_p, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._candidates = new FOrderedSet(proposed_p);
    }

    protected Control createCustomArea(Composite parent_p) {
        this._viewer = this.getChoiceViewer(parent_p);
        this.getShell().setSize(600, 600);
        UIUtil.centerShell(this.getShell());
        if (this.initiallySelectFirst()) {
            this._viewer.selectFirst();
        }
        this._viewer.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e_p) {
                ITreeSelection sel;
                boolean okEnabled = false;
                if (e_p.getSelection() instanceof ITreeSelection && !(sel = (ITreeSelection)e_p.getSelection()).isEmpty()) {
                    TreePath[] paths = sel.getPaths();
                    okEnabled = true;
                    int i = 0;
                    while (i < paths.length) {
                        TreePath path = paths[i];
                        Object last = path.getLastSegment();
                        if (last instanceof EObject) {
                            EObject elt = (EObject)last;
                            boolean bl = okEnabled = AbstractElementSelectionDialog.this._viewer.isValid(elt) && AbstractElementSelectionDialog.this.isEligible(elt);
                            if (!okEnabled) break;
                        }
                        ++i;
                    }
                }
                AbstractElementSelectionDialog.this.getOkButton().setEnabled(okEnabled);
            }
        });
        return this._viewer.getControl();
    }

    protected ModelSubsetViewer getChoiceViewer(Composite parent_p) {
        ModelSubsetViewer result = new ModelSubsetViewer(parent_p, false, true);
        result.setInput(this._candidates);
        return result;
    }

    public abstract T getChoice();

    protected Button getOkButton() {
        return this.getButton(0);
    }

    protected boolean initiallySelectFirst() {
        return true;
    }

    protected boolean isEligible(EObject element_p) {
        return true;
    }
}

