/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.processor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;

public class StructureSynchronizationProcessor
implements IProcessor {
    private static final String START_PAT = " [From '";
    private static final String END_PAT = "']";
    private ModelElement _context = null;
    private NamedElement _target = null;
    private NamedElement _synchronizedElement = null;
    private boolean _forceScenarioCreation = false;

    public StructureSynchronizationProcessor() {
    }

    public StructureSynchronizationProcessor(NamedElement context, NamedElement target) {
        this(context, target, false);
    }

    public StructureSynchronizationProcessor(NamedElement context, NamedElement target, boolean forceScenarioCreation) {
        this.setContext((ModelElement)context);
        this.setTarget(target);
        this._forceScenarioCreation = forceScenarioCreation;
    }

    public Object getName() {
        return "structure synchronization";
    }

    public Object getResult() {
        return this._synchronizedElement;
    }

    public void setContext(List<ModelElement> context) {
        if (context != null && context.size() > 0) {
            this.setContext(context.get(0));
        }
    }

    public void setContext(ModelElement context) {
        this._context = context;
    }

    public void setTarget(NamedElement target) {
        if (target instanceof ComponentArchitecture || target instanceof LogicalComponent || target instanceof PhysicalComponent) {
            this._target = target;
        }
    }

    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        if (this._context instanceof CapabilityPkg) {
            CapabilityRealizationPkg pkg = this.createCapabilityRealizationPkg((CapabilityPkg)this._context, this._target);
            this.synchronizeName((CapabilityPkg)this._context, pkg);
            this._synchronizedElement = pkg;
        } else if (this._context instanceof Capability) {
            CapabilityRealization cap = this.createCapabilityRealization((Capability)this._context, this._target);
            this.synchronizeName((Capability)this._context, cap);
            this._synchronizedElement = cap;
        } else if (this._context instanceof CapabilityRealizationPkg) {
            CapabilityRealizationPkg pkg = this.createCapabilityRealizationPkg((CapabilityRealizationPkg)this._context, this._target);
            this.synchronizeName((CapabilityRealizationPkg)this._context, pkg);
            this._synchronizedElement = pkg;
        } else if (this._context instanceof CapabilityRealization) {
            CapabilityRealization cap = this.createCapabilityRealization((CapabilityRealization)this._context, this._target);
            this.synchronizeName((CapabilityRealization)this._context, cap);
            this._synchronizedElement = cap;
        } else if (this._context instanceof Scenario) {
            Scenario sc = this.createScenario((Scenario)this._context, this._target);
            this.synchronizeName((Scenario)this._context, sc);
            this._synchronizedElement = sc;
        } else {
            throw new ProcessorException("Non supported object type.", (IProcessor)this);
        }
    }

    private void updateName(NamedElement referenceElt, NamedElement updatedElt) {
        if (referenceElt != null && updatedElt != null && updatedElt.getName() != referenceElt.getName()) {
            updatedElt.setName(referenceElt.getName());
        }
    }

    private void synchronizeName(Capability referenceElt, CapabilityRealization updatedElt) {
        if (referenceElt != null && updatedElt != null) {
            this.updateName((NamedElement)referenceElt, (NamedElement)updatedElt);
            if (referenceElt.eContainer() instanceof CapabilityPkg) {
                this.synchronizeName((CapabilityPkg)referenceElt.eContainer(), (CapabilityRealizationPkg)updatedElt.eContainer());
            }
        }
    }

    private void synchronizeName(CapabilityRealization referenceElt, CapabilityRealization updatedElt) {
        if (referenceElt != null && updatedElt != null) {
            updatedElt.setName(this.computeCapabilityRealizationName(referenceElt, (NamedElement)updatedElt));
            if (referenceElt.eContainer() instanceof CapabilityRealizationPkg) {
                this.synchronizeName((CapabilityRealizationPkg)referenceElt.eContainer(), (CapabilityRealizationPkg)updatedElt.eContainer());
            }
        }
    }

    private void synchronizeName(CapabilityPkg referenceElt, CapabilityRealizationPkg updatedElt) {
        if (referenceElt != null && updatedElt != null) {
            this.updateName((NamedElement)referenceElt, (NamedElement)updatedElt);
            if (referenceElt.eContainer() instanceof CapabilityPkg) {
                this.synchronizeName((CapabilityPkg)referenceElt.eContainer(), (CapabilityRealizationPkg)updatedElt.eContainer());
            }
        }
    }

    private void synchronizeName(CapabilityRealizationPkg referenceElt, CapabilityRealizationPkg updatedElt) {
        if (referenceElt != null && updatedElt != null) {
            this.updateName((NamedElement)referenceElt, (NamedElement)updatedElt);
            if (referenceElt.eContainer() instanceof CapabilityRealizationPkg) {
                this.synchronizeName((CapabilityRealizationPkg)referenceElt.eContainer(), (CapabilityRealizationPkg)updatedElt.eContainer());
            }
        }
    }

    private void synchronizeName(Scenario referenceElt, Scenario updatedElt) {
        if (referenceElt != null && updatedElt != null) {
            updatedElt.setName(this.computeScenarioName(referenceElt, (NamedElement)updatedElt));
            if (this._context.eContainer() instanceof Capability) {
                this.synchronizeName((Capability)this._context.eContainer(), (CapabilityRealization)updatedElt.eContainer());
            } else if (this._context.eContainer() instanceof CapabilityRealization) {
                this.synchronizeName((CapabilityRealization)this._context.eContainer(), (CapabilityRealization)updatedElt.eContainer());
            }
        }
    }

    private CapabilityRealizationPkg createCapabilityRealizationPkg(CapabilityPkg capPkg, NamedElement target) {
        boolean recentCreation = false;
        CapabilityRealizationPkg capabilityRealizationPkg = null;
        List relatedElements = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)capPkg, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION_PKG);
        for (CapellaElement relatedElement : relatedElements) {
            if (!EcoreUtil2.isContainedBy((EObject)relatedElement, (EObject)target)) continue;
            capabilityRealizationPkg = (CapabilityRealizationPkg)relatedElement;
        }
        if (capabilityRealizationPkg == null) {
            if (!(capPkg.eContainer() instanceof CapabilityPkg)) {
                AbstractCapabilityPkg abstractCapaPkg = null;
                if (target instanceof BlockArchitecture) {
                    abstractCapaPkg = ((BlockArchitecture)target).getOwnedAbstractCapabilityPkg();
                } else if (target instanceof Block) {
                    abstractCapaPkg = ((Block)target).getOwnedAbstractCapabilityPkg();
                }
                capabilityRealizationPkg = abstractCapaPkg != null ? (CapabilityRealizationPkg)abstractCapaPkg : LaFactory.eINSTANCE.createCapabilityRealizationPkg(capPkg.getName());
            } else {
                capabilityRealizationPkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(capPkg.getName());
            }
            recentCreation = true;
        }
        if (capPkg.eContainer() instanceof CapabilityPkg) {
            CapabilityRealizationPkg parentCapabilityRealizationPkg = this.createCapabilityRealizationPkg((CapabilityPkg)capPkg.eContainer(), target);
            parentCapabilityRealizationPkg.getOwnedCapabilityRealizationPkgs().add((Object)capabilityRealizationPkg);
        } else if (target instanceof BlockArchitecture) {
            ((BlockArchitecture)target).setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capabilityRealizationPkg);
        } else if (target instanceof Block) {
            ((Block)target).setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capabilityRealizationPkg);
        }
        if (capabilityRealizationPkg != null && recentCreation) {
            RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)capabilityRealizationPkg, (NamedElement)capPkg);
        }
        return capabilityRealizationPkg;
    }

    private CapabilityRealizationPkg createCapabilityRealizationPkg(CapabilityRealizationPkg capPkg, NamedElement target) {
        boolean recentCreation = false;
        CapabilityRealizationPkg capabilityRealizationPkg = null;
        if ((capPkg.eContainer() instanceof Block || capPkg.eContainer() instanceof BlockArchitecture) && target instanceof Block) {
            capabilityRealizationPkg = (CapabilityRealizationPkg)((Block)target).getOwnedAbstractCapabilityPkg();
        }
        if (capabilityRealizationPkg == null) {
            List relatedElements = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)capPkg, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION_PKG);
            for (CapellaElement relatedElement : relatedElements) {
                if (!EcoreUtil2.isContainedBy((EObject)relatedElement, (EObject)target)) continue;
                capabilityRealizationPkg = (CapabilityRealizationPkg)relatedElement;
            }
        }
        if (capabilityRealizationPkg == null) {
            if (!(capPkg.eContainer() instanceof CapabilityPkg)) {
                AbstractCapabilityPkg abstractCapaPkg = null;
                if (target instanceof BlockArchitecture) {
                    abstractCapaPkg = ((BlockArchitecture)target).getOwnedAbstractCapabilityPkg();
                } else if (target instanceof Block) {
                    abstractCapaPkg = ((Block)target).getOwnedAbstractCapabilityPkg();
                }
                capabilityRealizationPkg = abstractCapaPkg != null ? (CapabilityRealizationPkg)abstractCapaPkg : LaFactory.eINSTANCE.createCapabilityRealizationPkg(capPkg.getName());
            } else {
                capabilityRealizationPkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(capPkg.getName());
            }
            recentCreation = true;
        }
        if (capPkg.eContainer() instanceof CapabilityRealizationPkg) {
            CapabilityRealizationPkg parentCapabilityRealizationPkg = this.createCapabilityRealizationPkg((CapabilityRealizationPkg)capPkg.eContainer(), target);
            parentCapabilityRealizationPkg.getOwnedCapabilityRealizationPkgs().add((Object)capabilityRealizationPkg);
        } else if (target instanceof BlockArchitecture) {
            ((BlockArchitecture)target).setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capabilityRealizationPkg);
        } else if (target instanceof Block) {
            ((Block)target).setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capabilityRealizationPkg);
        }
        if (capabilityRealizationPkg != null && recentCreation) {
            RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)capabilityRealizationPkg, (NamedElement)capPkg);
        }
        return capabilityRealizationPkg;
    }

    private CapabilityRealization createCapabilityRealization(Capability capability, NamedElement target) {
        boolean recentCreation = false;
        CapabilityRealization capabilityRealization = null;
        List relatedElements = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)capability, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
        for (CapellaElement relatedElement : relatedElements) {
            if (!EcoreUtil2.isContainedBy((EObject)relatedElement, (EObject)target)) continue;
            capabilityRealization = (CapabilityRealization)relatedElement;
        }
        if (capabilityRealization == null) {
            capabilityRealization = LaFactory.eINSTANCE.createCapabilityRealization(capability.getName());
            recentCreation = true;
        }
        if (capability.eContainer() instanceof CapabilityPkg) {
            CapabilityRealizationPkg parentCapabilityRealizationPkg = this.createCapabilityRealizationPkg((CapabilityPkg)capability.eContainer(), target);
            parentCapabilityRealizationPkg.getOwnedCapabilityRealizations().add((Object)capabilityRealization);
        }
        if (capabilityRealization != null && recentCreation) {
            RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)capabilityRealization, (NamedElement)capability);
        }
        return capabilityRealization;
    }

    private CapabilityRealization createCapabilityRealization(CapabilityRealization capabilityReal, NamedElement target) {
        boolean recentCreation = false;
        CapabilityRealization capabilityRealization = null;
        List relatedElements = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)capabilityReal, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
        for (CapellaElement relatedElement : relatedElements) {
            if (!EcoreUtil2.isContainedBy((EObject)relatedElement, (EObject)target)) continue;
            capabilityRealization = (CapabilityRealization)relatedElement;
        }
        if (capabilityRealization == null) {
            capabilityRealization = LaFactory.eINSTANCE.createCapabilityRealization(this.computeCapabilityRealizationName(capabilityReal, target));
            recentCreation = true;
        }
        if (capabilityReal.eContainer() instanceof CapabilityRealizationPkg) {
            CapabilityRealizationPkg parentCapabilityRealizationPkg = this.createCapabilityRealizationPkg((CapabilityRealizationPkg)capabilityReal.eContainer(), target);
            parentCapabilityRealizationPkg.getOwnedCapabilityRealizations().add((Object)capabilityRealization);
        }
        if (capabilityRealization != null && recentCreation) {
            RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)capabilityRealization, (NamedElement)capabilityReal);
        }
        return capabilityRealization;
    }

    private String computeCapabilityRealizationName(CapabilityRealization capabilityReal, NamedElement target) {
        String srcCapName;
        int startIndex;
        StringBuffer newName = new StringBuffer();
        LogicalComponent containerLc = null;
        if (CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)target) || CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)target) || target instanceof EPBSArchitecture) {
            return capabilityReal.getName();
        }
        containerLc = (LogicalComponent)EcoreUtil2.getFirstContainer((EObject)capabilityReal, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        if (containerLc == null) {
            LogicalArchitecture la = (LogicalArchitecture)EcoreUtil2.getFirstContainer((EObject)capabilityReal, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE);
            containerLc = SystemEngineeringExt.getRootLogicalComponent((LogicalArchitecture)la);
        }
        if ((startIndex = (srcCapName = capabilityReal.getName()).indexOf(START_PAT)) != -1) {
            newName.append(srcCapName.substring(0, startIndex));
        } else {
            newName.append(srcCapName);
        }
        newName.append(START_PAT).append(containerLc.getName()).append(END_PAT);
        return newName.toString();
    }

    private String computeScenarioName(Scenario scenario, NamedElement target) {
        String srcCapName;
        int startIndex;
        StringBuffer newName = new StringBuffer();
        LogicalComponent containerLc = null;
        if (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)scenario)) {
            return scenario.getName();
        }
        if (CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)target) || CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)target) || target instanceof EPBSArchitecture) {
            return scenario.getName();
        }
        containerLc = (LogicalComponent)EcoreUtil2.getFirstContainer((EObject)scenario, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        if (containerLc == null) {
            LogicalArchitecture la = (LogicalArchitecture)EcoreUtil2.getFirstContainer((EObject)scenario, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE);
            containerLc = SystemEngineeringExt.getRootLogicalComponent((LogicalArchitecture)la);
        }
        if ((startIndex = (srcCapName = scenario.getName()).indexOf(START_PAT)) != -1) {
            newName.append(srcCapName.substring(0, startIndex));
        } else {
            newName.append(srcCapName);
        }
        newName.append(START_PAT).append(containerLc.getName()).append(END_PAT);
        return newName.toString();
    }

    private Scenario createScenario(Scenario scenario, NamedElement target) {
        CapabilityRealization abstractCapabilityContext;
        boolean recentCreation = false;
        Scenario sc = null;
        if (!this._forceScenarioCreation) {
            List relatedElements = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)scenario, (EClass)InteractionPackage.Literals.SCENARIO);
            for (CapellaElement relatedElement : relatedElements) {
                if (!EcoreUtil2.isContainedBy((EObject)relatedElement, (EObject)target)) continue;
                sc = (Scenario)relatedElement;
            }
        }
        if (sc == null) {
            sc = InteractionFactory.eINSTANCE.createScenario(scenario.getName());
            sc.setKind(scenario.getKind());
            recentCreation = true;
        }
        if (scenario.eContainer() instanceof Capability) {
            abstractCapabilityContext = this.createCapabilityRealization((Capability)scenario.eContainer(), target);
            abstractCapabilityContext.getOwnedScenarios().add((Object)sc);
        } else if (scenario.eContainer() instanceof CapabilityRealization) {
            abstractCapabilityContext = this.createCapabilityRealization((CapabilityRealization)scenario.eContainer(), target);
            abstractCapabilityContext.getOwnedScenarios().add((Object)sc);
        }
        if (sc != null && recentCreation) {
            RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)sc, (NamedElement)scenario);
        }
        return sc;
    }
}

