/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ExclusionInclusionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.RemoveLinkedFolderDialog;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;

public class ClasspathModifierQueries {
    public static OutputFolderQuery getDefaultFolderQuery(final Shell shell, IPath outputLocation) {
        return new OutputFolderQuery(outputLocation){
            protected IPath fOutputLocation;
            protected boolean fRemoveProject;

            @Override
            public boolean doQuery(final boolean editingOutputFolder, final OutputFolderValidator validator, IJavaProject project) throws JavaModelException {
                final boolean[] result = new boolean[1];
                this.fRemoveProject = false;
                this.fOutputLocation = project.getOutputLocation();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell sh = shell != null ? shell : JavaPlugin.getActiveWorkbenchShell();
                        String title = NewWizardMessages.ClasspathModifier_ChangeOutputLocationDialog_title;
                        if (fDesiredOutputLocation.segmentCount() == 1) {
                            String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
                            IPath newOutputFolder = fDesiredOutputLocation.append(outputFolderName);
                            newOutputFolder = this.getValidPath(newOutputFolder, validator);
                            String message = Messages.format(NewWizardMessages.ClasspathModifier_ChangeOutputLocationDialog_project_outputLocation, BasicElementLabels.getPathLabel((IPath)newOutputFolder, (boolean)false));
                            fRemoveProject = true;
                            if (MessageDialog.openConfirm((Shell)sh, (String)title, (String)message)) {
                                fOutputLocation = newOutputFolder;
                                result[0] = true;
                            }
                        } else {
                            IPath newOutputFolder = fDesiredOutputLocation;
                            newOutputFolder = this.getValidPath(newOutputFolder, validator);
                            if (editingOutputFolder) {
                                fOutputLocation = newOutputFolder;
                                result[0] = true;
                                return;
                            }
                            String message = NewWizardMessages.ClasspathModifier_ChangeOutputLocationDialog_project_message;
                            fRemoveProject = true;
                            if (MessageDialog.openQuestion((Shell)sh, (String)title, (String)message)) {
                                fOutputLocation = newOutputFolder;
                                result[0] = true;
                            }
                        }
                    }
                });
                return result[0];
            }

            @Override
            public IPath getOutputLocation() {
                return this.fOutputLocation;
            }

            @Override
            public boolean removeProjectFromClasspath() {
                return this.fRemoveProject;
            }

            private IPath getValidPath(IPath newOutputFolder, OutputFolderValidator validator) {
                int i = 1;
                IPath path = newOutputFolder;
                while (!validator.validate(path)) {
                    path = new Path(String.valueOf(newOutputFolder.toString()) + i);
                    ++i;
                }
                return path;
            }
        };
    }

    public static IInclusionExclusionQuery getDefaultInclusionExclusionQuery(final Shell shell) {
        return new IInclusionExclusionQuery(){
            protected IPath[] fInclusionPattern;
            protected IPath[] fExclusionPattern;

            @Override
            public boolean doQuery(final CPListElement element, final boolean focusOnExcluded) {
                final boolean[] result = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell sh = shell != null ? shell : JavaPlugin.getActiveWorkbenchShell();
                        ExclusionInclusionDialog dialog = new ExclusionInclusionDialog(sh, element, focusOnExcluded);
                        result[0] = dialog.open() == 0;
                        fInclusionPattern = dialog.getInclusionPattern();
                        fExclusionPattern = dialog.getExclusionPattern();
                    }
                });
                return result[0];
            }

            @Override
            public IPath[] getInclusionPattern() {
                return this.fInclusionPattern;
            }

            @Override
            public IPath[] getExclusionPattern() {
                return this.fExclusionPattern;
            }
        };
    }

    public static IAddArchivesQuery getDefaultArchivesQuery(final Shell shell) {
        return new IAddArchivesQuery(){

            @Override
            public IPath[] doQuery() {
                final IPath[][] selected = new IPath[1][];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell sh = shell != null ? shell : JavaPlugin.getActiveWorkbenchShell();
                        selected[0] = BuildPathDialogAccess.chooseExternalJAREntries(sh);
                    }
                });
                if (selected[0] == null) {
                    return new IPath[0];
                }
                return selected[0];
            }
        };
    }

    public static IRemoveLinkedFolderQuery getDefaultRemoveLinkedFolderQuery(final Shell shell) {
        return new IRemoveLinkedFolderQuery(){

            @Override
            public final int doQuery(final IFolder folder) {
                final int[] result = new int[]{1};
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public final void run() {
                        RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(shell != null ? shell : JavaPlugin.getActiveWorkbenchShell(), folder);
                        int status = dialog.open();
                        result[0] = status == 0 ? dialog.getRemoveStatus() : 0;
                    }
                });
                return result[0];
            }
        };
    }

    public static IAddLibrariesQuery getDefaultLibrariesQuery(final Shell shell) {
        return new IAddLibrariesQuery(){

            @Override
            public IClasspathEntry[] doQuery(final IJavaProject project, final IClasspathEntry[] entries) {
                final IClasspathEntry[][] selected = new IClasspathEntry[1][];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell sh = shell != null ? shell : JavaPlugin.getActiveWorkbenchShell();
                        selected[0] = BuildPathDialogAccess.chooseContainerEntries(sh, project, entries);
                    }
                });
                if (selected[0] == null) {
                    return new IClasspathEntry[0];
                }
                return selected[0];
            }
        };
    }

    public static ICreateFolderQuery getDefaultCreateFolderQuery(final Shell shell, final IJavaProject project) {
        return new ICreateFolderQuery(){
            private IFolder fNewFolder;

            @Override
            public boolean doQuery() {
                final boolean[] isOK = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell sh = shell != null ? shell : JavaPlugin.getActiveWorkbenchShell();
                        NewFolderDialog dialog = new NewFolderDialog(sh, (IContainer)project.getProject());
                        boolean bl = isOK[0] = dialog.open() == 0;
                        if (isOK[0]) {
                            IResource sourceContainer = (IResource)dialog.getResult()[0];
                            if (sourceContainer instanceof IFolder) {
                                fNewFolder = (IFolder)sourceContainer;
                            } else {
                                fNewFolder = null;
                            }
                        }
                    }
                });
                return isOK[0];
            }

            @Override
            public boolean isSourceFolder() {
                return true;
            }

            @Override
            public IFolder getCreatedFolder() {
                return this.fNewFolder;
            }
        };
    }

    public static interface IAddArchivesQuery {
        public IPath[] doQuery();
    }

    public static interface IAddLibrariesQuery {
        public IClasspathEntry[] doQuery(IJavaProject var1, IClasspathEntry[] var2);
    }

    public static interface ICreateFolderQuery {
        public boolean doQuery();

        public boolean isSourceFolder();

        public IFolder getCreatedFolder();
    }

    public static interface IInclusionExclusionQuery {
        public boolean doQuery(CPListElement var1, boolean var2);

        public IPath[] getInclusionPattern();

        public IPath[] getExclusionPattern();
    }

    public static interface IOutputLocationQuery {
        public boolean doQuery(CPListElement var1);

        public IPath getOutputLocation();

        public OutputFolderQuery getOutputFolderQuery(IPath var1) throws JavaModelException;
    }

    public static interface IRemoveLinkedFolderQuery {
        public static final int REMOVE_CANCEL = 0;
        public static final int REMOVE_BUILD_PATH = 1;
        public static final int REMOVE_BUILD_PATH_AND_FOLDER = 2;

        public int doQuery(IFolder var1);
    }

    public static abstract class OutputFolderQuery {
        protected IPath fDesiredOutputLocation;

        public OutputFolderQuery(IPath outputLocation) {
            if (outputLocation != null) {
                this.fDesiredOutputLocation = outputLocation.makeAbsolute();
            }
        }

        public IPath getDesiredOutputLocation() {
            return this.fDesiredOutputLocation;
        }

        public abstract IPath getOutputLocation();

        public abstract boolean removeProjectFromClasspath();

        public abstract boolean doQuery(boolean var1, OutputFolderValidator var2, IJavaProject var3) throws JavaModelException;
    }

    public static abstract class OutputFolderValidator {
        protected IClasspathEntry[] fEntries;
        protected List<?> fElements;

        public OutputFolderValidator(List<?> newElements, IJavaProject project) throws JavaModelException {
            this.fEntries = project.getRawClasspath();
            this.fElements = newElements;
        }

        public abstract boolean validate(IPath var1);
    }
}

