/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.ui.toolkit.dialogs.ImpactAnalysisDialog;
import org.polarsys.capella.core.ui.toolkit.dialogs.Messages;

public class ConfirmDeleteCapellaElementDialog
extends ImpactAnalysisDialog {
    public static final String DELETE_ANALYSIS_DIALOG_ELEMENTS = "org.polarsys.capella.core.ui.toolkit.dialogs.confirmDelete.elements";
    public static final String DELETE_ANALYSIS_DIALOG_REFERENCING_ELEMENTS = "org.polarsys.capella.core.ui.toolkit.dialogs.confirmDelete.referencingElements";
    private TreeViewer referencingElementsViewer;
    private TreeViewer elementsToDeleteViewer;
    private Object[] expendedElements;
    private boolean isMultipleSelection;
    private Button resourceCheckReferencingElemntButton;

    public ConfirmDeleteCapellaElementDialog(List<?> elementsToDelete, boolean isMultipleSelection, Object[] expendedElements) {
        super(elementsToDelete, Messages.CapellaDeleteCommand_Label, Messages.CapellaDeleteCommand_ConfirmDeletionQuestion, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 3, isMultipleSelection);
        this.expendedElements = expendedElements;
        this.isMultipleSelection = isMultipleSelection;
        this.setBlockOnOpen(true);
    }

    protected Control createCustomArea(Composite parentComposite) {
        GridLayout layout = (GridLayout)parentComposite.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        Group deletedElementsGroup = new Group(parentComposite, 0);
        deletedElementsGroup.setText(Messages.CapellaDeleteCommand_ImpactAnalysis_DeletedElements_Group_Title);
        deletedElementsGroup.setToolTipText(Messages.CapellaDeleteCommand_ImpactAnalysis_DeletedElements_Group_Tooltip);
        deletedElementsGroup.setLayout((Layout)new GridLayout());
        deletedElementsGroup.setLayoutData((Object)new GridData(1808));
        this.elementsToDeleteViewer = this.createViewer((Composite)deletedElementsGroup, DELETE_ANALYSIS_DIALOG_ELEMENTS);
        this.elementsToDeleteViewer.setInput((Object)this.getInitialInputData());
        this.createResourceCheckButton((Composite)deletedElementsGroup, this.elementsToDeleteViewer);
        this.createReferencingElementViewer(parentComposite);
        this.elementsToDeleteViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ImpactAnalysisDialog.ImpactAnalysisLabelProvider(this.elementsToDeleteViewer, 3), (ILabelDecorator)PlatformUI.getWorkbench().getDecoratorManager()));
        this.elementsToDeleteViewer.setSelection((ISelection)new StructuredSelection(this.expendedElements), true);
        this.elementsToDeleteViewer.getControl().setFocus();
        return parentComposite;
    }

    protected void createReferencingElementViewer(Composite parentComposite) {
        Group referencingElementsGroup = new Group(parentComposite, 0);
        referencingElementsGroup.setText(Messages.CapellaDeleteCommand_ImpactAnalysis_ReferencingElements_Group_Title);
        referencingElementsGroup.setToolTipText(Messages.CapellaDeleteCommand_ImpactAnalysis_ReferencingElements_Group_Tooltip);
        referencingElementsGroup.setLayout((Layout)new GridLayout());
        referencingElementsGroup.setLayoutData((Object)new GridData(1808));
        this.referencingElementsViewer = this.createViewer((Composite)referencingElementsGroup, DELETE_ANALYSIS_DIALOG_REFERENCING_ELEMENTS);
        this.referencingElementsViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ImpactAnalysisDialog.ImpactAnalysisLabelProvider(this.referencingElementsViewer, 9), (ILabelDecorator)PlatformUI.getWorkbench().getDecoratorManager()));
        this.resourceCheckReferencingElemntButton = this.createResourceCheckButton((Composite)referencingElementsGroup, this.referencingElementsViewer);
        this.registerElementsToDeleteListener();
    }

    private void registerElementsToDeleteListener() {
        this.elementsToDeleteViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                IStructuredSelection ssel = (IStructuredSelection)event_p.getSelection();
                List selectedElements = ssel.toList();
                HashSet<? extends EObject> referencingElements = new HashSet<EObject>(0);
                for (Object currentSelectedElement : selectedElements) {
                    if (!((TreeData)ConfirmDeleteCapellaElementDialog.this.elementsToDeleteViewer.getInput()).isValid(currentSelectedElement) || !(currentSelectedElement instanceof EObject)) continue;
                    referencingElements.addAll(ConfirmDeleteCapellaElementDialog.this.getReferencingElements(currentSelectedElement));
                }
                ConfirmDeleteCapellaElementDialog.this.referencingElementsViewer.setInput((Object)ConfirmDeleteCapellaElementDialog.this.getTreeViewerItems(ConfirmDeleteCapellaElementDialog.this.resourceCheckReferencingElemntButton.getSelection(), new ArrayList<Object>(referencingElements)));
            }
        });
    }

    protected Collection<? extends EObject> getReferencingElements(Object currentSelectedElement) {
        List objects = CrossReferencerHelper.getReferencingElements((EObject)((EObject)currentSelectedElement));
        objects.addAll(RepresentationHelper.getAllRepresentationDescriptorsAnnotatedBy(Collections.singletonList((EObject)currentSelectedElement)));
        return objects;
    }

    protected int getDialogWidth() {
        return 800;
    }

    protected TreeViewer createViewer(Composite parentComposite, final String location) {
        TreeAndListViewer treeViewer = new TreeAndListViewer(parentComposite, this.isMultipleSelection, 2){

            public String getContextMenuLocation() {
                return location;
            }
        };
        TreeViewer viewer = treeViewer.getClientViewer();
        viewer.setContentProvider((IContentProvider)new DataContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ImpactAnalysisDialog.ImpactAnalysisLabelProvider(viewer, 3));
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.setSorter((ViewerSorter)new ImpactAnalysisDialog.ImpactAnalysisSorter());
        return viewer;
    }

    protected Button createResourceCheckButton(Composite parentComposite, final TreeViewer treeViewer) {
        Button resourceCheckButton = new Button(parentComposite, 32);
        resourceCheckButton.setLayoutData((Object)new GridData(768));
        resourceCheckButton.setText(Messages.ImpactAnalysisDialog_ResourceButton_Title);
        resourceCheckButton.setSelection(false);
        resourceCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ConfirmDeleteCapellaElementDialog.this.handleResourceCheckButtonClicked(((Button)event_p.widget).getSelection(), treeViewer);
            }
        });
        return resourceCheckButton;
    }

    protected void handleResourceCheckButtonClicked(boolean isChecked_p, TreeViewer clientViewer) {
        TreeData input = null;
        List referencingElements = ((TreeData)clientViewer.getInput()).getValidElements();
        input = super.getTreeViewerItems(isChecked_p, referencingElements);
        clientViewer.setInput((Object)input);
    }
}

