/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.delegates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.activity.ActivityPackage;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.common.data.behavior.AbstractBehavior;
import org.polarsys.capella.common.data.helpers.activity.delegates.ActivityNodeHelper;
import org.polarsys.capella.common.data.helpers.modellingcore.delegates.AbstractTypeHelper;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.fa.FunctionSpecification;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamespaceHelper;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.information.delegates.AbstractInstanceHelper;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractFunctionAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.la.CapabilityRealization;

public class AbstractFunctionHelper {
    private static AbstractFunctionHelper instance;

    private AbstractFunctionHelper() {
    }

    public static AbstractFunctionHelper getInstance() {
        if (instance == null) {
            instance = new AbstractFunctionHelper();
        }
        return instance;
    }

    public Object doSwitch(AbstractFunction element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__ALLOCATION_BLOCKS)) {
            ret = this.getAllocationBlocks(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__COMPONENT_FUNCTIONAL_ALLOCATIONS)) {
            ret = this.getComponentFunctionalAllocations(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__OUT_FUNCTION_REALIZATIONS)) {
            ret = this.getOutFunctionRealizations(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__IN_FUNCTION_REALIZATIONS)) {
            ret = this.getInFunctionRealizations(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__INVOLVING_CAPABILITIES)) {
            ret = this.getInvolvingCapabilities(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__INVOLVING_CAPABILITY_REALIZATIONS)) {
            ret = this.getInvolvingCapabilityRealizations(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__INVOLVING_FUNCTIONAL_CHAINS)) {
            ret = this.getInvolvingFunctionalChains(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__LINKED_FUNCTION_SPECIFICATION)) {
            ret = this.getLinkedFunctionSpecification(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__LINKED_STATE_MACHINE)) {
            ret = this.getLinkedStateMachine(element);
        } else if (feature.equals(FaPackage.Literals.ABSTRACT_FUNCTION__SUB_FUNCTIONS)) {
            ret = this.getSubFunctions(element);
        } else if (feature.equals(ActivityPackage.Literals.ACTIVITY_NODE__INCOMING)) {
            ret = this.getIncomingEdges(element, feature);
        } else if (feature.equals(ActivityPackage.Literals.ACTIVITY_NODE__OUTGOING)) {
            ret = this.getOutgoingEdges(element, feature);
        }
        if (ret == null) {
            ret = InvolvedElementHelper.getInstance().doSwitch((InvolvedElement)element, feature);
        }
        if (ret == null) {
            ret = AbstractInstanceHelper.getInstance().doSwitch((AbstractInstance)element, feature);
        }
        if (ret == null) {
            ret = ActivityNodeHelper.getInstance().doSwitch((ActivityNode)element, feature);
        }
        if (ret == null) {
            ret = AbstractTypeHelper.getInstance().doSwitch((AbstractType)element, feature);
        }
        if (ret == null) {
            ret = NamespaceHelper.getInstance().doSwitch((Namespace)element, feature);
        }
        return ret;
    }

    protected List<FunctionRealization> getInFunctionRealizations(AbstractFunction element) {
        ArrayList<FunctionRealization> ret = new ArrayList<FunctionRealization>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            if (!(trace instanceof FunctionRealization)) continue;
            ret.add((FunctionRealization)trace);
        }
        return ret;
    }

    protected List<FunctionRealization> getOutFunctionRealizations(AbstractFunction element) {
        ArrayList<FunctionRealization> ret = new ArrayList<FunctionRealization>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            if (!(trace instanceof FunctionRealization)) continue;
            ret.add((FunctionRealization)trace);
        }
        return ret;
    }

    protected List<ComponentFunctionalAllocation> getComponentFunctionalAllocations(AbstractFunction element) {
        ArrayList<ComponentFunctionalAllocation> ret = new ArrayList<ComponentFunctionalAllocation>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            if (!(trace instanceof ComponentFunctionalAllocation)) continue;
            ret.add((ComponentFunctionalAllocation)trace);
        }
        return ret;
    }

    protected List<AbstractFunctionalBlock> getAllocationBlocks(AbstractFunction element) {
        ArrayList<AbstractFunctionalBlock> ret = new ArrayList<AbstractFunctionalBlock>();
        for (ComponentFunctionalAllocation alloc : element.getComponentFunctionalAllocations()) {
            AbstractFunctionalBlock block = alloc.getBlock();
            if (block == null) continue;
            ret.add(block);
        }
        return ret;
    }

    protected List<Capability> getInvolvingCapabilities(AbstractFunction element) {
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (Involvement inv : element.getInvolvingInvolvements()) {
            AbstractCapability cap;
            if (!(inv instanceof AbstractFunctionAbstractCapabilityInvolvement) || !((cap = ((AbstractFunctionAbstractCapabilityInvolvement)inv).getCapability()) instanceof Capability)) continue;
            ret.add((Capability)cap);
        }
        return ret;
    }

    protected List<CapabilityRealization> getInvolvingCapabilityRealizations(AbstractFunction element) {
        ArrayList<CapabilityRealization> ret = new ArrayList<CapabilityRealization>();
        for (Involvement inv : element.getInvolvingInvolvements()) {
            AbstractCapability cap;
            if (!(inv instanceof AbstractFunctionAbstractCapabilityInvolvement) || !((cap = ((AbstractFunctionAbstractCapabilityInvolvement)inv).getCapability()) instanceof CapabilityRealization)) continue;
            ret.add((CapabilityRealization)cap);
        }
        return ret;
    }

    protected List<AbstractFunction> getSubFunctions(AbstractFunction element) {
        return (List)FunctionExt.getFirstLevelAbstractFunctions(element);
    }

    protected List<FunctionalChain> getInvolvingFunctionalChains(AbstractFunction element) {
        ArrayList<FunctionalChain> result = new ArrayList<FunctionalChain>();
        for (Involvement involvement : element.getInvolvingInvolvements()) {
            InvolverElement fc;
            if (!(involvement instanceof FunctionalChainInvolvement) || !((fc = involvement.getInvolver()) instanceof FunctionalChain) || result.contains(fc)) continue;
            result.add((FunctionalChain)fc);
        }
        return result;
    }

    protected FunctionSpecification getLinkedFunctionSpecification(AbstractFunction element) {
        AbstractBehavior behavior = element.getBehavior();
        if (behavior != null && behavior instanceof FunctionSpecification) {
            return (FunctionSpecification)behavior;
        }
        return null;
    }

    protected StateMachine getLinkedStateMachine(AbstractFunction element) {
        AbstractBehavior behavior = element.getBehavior();
        if (behavior != null && behavior instanceof StateMachine) {
            return (StateMachine)behavior;
        }
        return null;
    }

    protected List<ActivityEdge> getIncomingEdges(AbstractFunction element, EStructuralFeature feature) {
        ArrayList<ActivityEdge> res = new ArrayList<ActivityEdge>();
        if (element.getInputs().isEmpty()) {
            res.addAll((Collection)ActivityNodeHelper.getInstance().doSwitch((ActivityNode)element, feature));
        } else {
            for (InputPin inputPin : element.getInputs()) {
                res.addAll((Collection)ActivityNodeHelper.getInstance().doSwitch((ActivityNode)inputPin, feature));
            }
        }
        return res;
    }

    protected List<ActivityEdge> getOutgoingEdges(AbstractFunction element, EStructuralFeature feature) {
        ArrayList<ActivityEdge> res = new ArrayList<ActivityEdge>();
        if (element.getOutputs().isEmpty()) {
            res.addAll((Collection)ActivityNodeHelper.getInstance().doSwitch((ActivityNode)element, feature));
        } else {
            for (OutputPin outputPin : element.getOutputs()) {
                res.addAll((Collection)ActivityNodeHelper.getInstance().doSwitch((ActivityNode)outputPin, feature));
            }
        }
        return res;
    }
}

