/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.services;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.helpers.fa.services.BusPattern;
import org.polarsys.capella.core.data.helpers.fa.services.EndDescription;
import org.polarsys.capella.core.data.helpers.fa.services.PatternHelper;

public abstract class BusPatternHelper
extends PatternHelper {
    public Map<EClass, EndDescription> getEndsMap() {
        if (this.getPattern() instanceof BusPattern) {
            return ((BusPattern)this.getPattern()).getEndsMap();
        }
        return null;
    }

    public EClass getBusEClass() {
        if (this.getPattern() instanceof BusPattern) {
            return ((BusPattern)this.getPattern()).getBusEClass();
        }
        return null;
    }

    @Override
    public Set<EObject> getAvailable(EObject from) {
        if (from == null) {
            return null;
        }
        Map<EClass, EndDescription> endsMap = this.getEndsMap();
        EClass busEClass = this.getBusEClass();
        Set<EClass> endsEClass = endsMap.keySet();
        if (endsMap == null || busEClass == null) {
            return null;
        }
        HashSet<EObject> available = new HashSet<EObject>();
        if (busEClass.isSuperTypeOf(from.eClass())) {
            return available;
        }
        for (EClass endEClass : endsEClass) {
            if (!busEClass.isSuperTypeOf(from.eClass())) continue;
            return available;
        }
        return available;
    }

    @Override
    public Set<EObject> getCurrent(EObject from) {
        if (from == null) {
            return null;
        }
        HashSet<EObject> current = new HashSet<EObject>();
        Map<EClass, EndDescription> endsMap = this.getEndsMap();
        EClass busEClass = this.getBusEClass();
        Set<EClass> endsEClass = endsMap.keySet();
        if (endsMap == null || busEClass == null) {
            return null;
        }
        if (busEClass.isSuperTypeOf(from.eClass())) {
            for (EClass endEClass : endsEClass) {
                EndDescription desc = endsMap.get(endEClass);
                String endName = desc.getEndName();
                if (endName == "" || busEClass.getEAllReferences().isEmpty()) continue;
                EList references = busEClass.getEAllReferences();
                for (EReference ref : references) {
                    if (ref.getName().compareTo(endName) != 0) continue;
                    if (ref.isMany()) {
                        EList many = (EList)from.eGet((EStructuralFeature)ref, true);
                        if (many != null && many.isEmpty()) {
                            current.addAll((Collection<EObject>)many);
                        }
                        return current;
                    }
                    EObject single = (EObject)from.eGet((EStructuralFeature)ref, true);
                    if (single != null) {
                        current.add(single);
                    }
                    return current;
                }
            }
            return current;
        }
        for (EClass endEClass : endsEClass) {
            EndDescription desc = endsMap.get(endEClass);
            String busName = desc.getBusName();
            if (busName == "" || endEClass.getEAllReferences().isEmpty()) continue;
            EList references = busEClass.getEAllReferences();
            for (EReference ref : references) {
                if (ref.getName().compareTo(busName) != 0) continue;
                if (ref.isMany()) {
                    EList many = (EList)from.eGet((EStructuralFeature)ref, true);
                    if (many != null && many.isEmpty()) {
                        current.addAll((Collection<EObject>)many);
                    }
                    return current;
                }
                EObject single = (EObject)from.eGet((EStructuralFeature)ref, true);
                if (single != null) {
                    current.add(single);
                }
                return current;
            }
        }
        return current;
    }

    @Override
    public boolean validatePattern(Set<EObject> objects) {
        if (objects == null || objects.isEmpty()) {
            return false;
        }
        return false;
    }

    @Override
    public boolean validateDisconnection(Set<EObject> list) {
        return false;
    }

    @Override
    public boolean validateConnection(Set<EObject> list) {
        return false;
    }
}

