/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ExchangeLink;
import org.polarsys.capella.core.data.fa.ExchangeSpecification;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionSpecification;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.information.Port;

public class FunctionalExt {
    public static final FunctionSpecification getParent(FunctionSpecification function) {
        FunctionSpecification parent = null;
        if (function != null && function.eContainer() instanceof FunctionSpecification) {
            parent = (FunctionSpecification)function.eContainer();
        }
        return parent;
    }

    public static final FunctionSpecification getRoot(FunctionSpecification function) {
        FunctionSpecification root = function;
        while (root != null && root.eContainer() instanceof FunctionSpecification) {
            root = (FunctionSpecification)function.eContainer();
        }
        return root;
    }

    public static List<Port> getRelatedPorts(ComponentExchange componentExchange) {
        ComponentExchangeEnd end;
        ArrayList<Port> ports = new ArrayList<Port>();
        if (componentExchange.getSource() instanceof ComponentExchangeEnd) {
            end = (ComponentExchangeEnd)componentExchange.getSource();
            if (end.getPort() != null) {
                ports.add(end.getPort());
            }
        } else if (componentExchange.getSource() instanceof Port) {
            ports.add((Port)componentExchange.getSource());
        }
        if (componentExchange.getTarget() instanceof ComponentExchangeEnd) {
            end = (ComponentExchangeEnd)componentExchange.getTarget();
            if (end.getPort() != null) {
                ports.add(end.getPort());
            }
        } else if (componentExchange.getTarget() instanceof Port) {
            ports.add((Port)componentExchange.getTarget());
        }
        return ports;
    }

    public static List<Part> getRelatedParts(ComponentExchange componentExchange) {
        ComponentExchangeEnd end;
        ArrayList<Part> parts = new ArrayList<Part>();
        if (componentExchange.getSource() instanceof ComponentExchangeEnd) {
            end = (ComponentExchangeEnd)componentExchange.getSource();
            if (end.getPart() != null && end.getPart() instanceof Part) {
                parts.add((Part)end.getPart());
            }
        } else if (componentExchange.getSource() instanceof Part) {
            parts.add((Part)componentExchange.getSource());
        }
        if (componentExchange.getTarget() instanceof ComponentExchangeEnd) {
            end = (ComponentExchangeEnd)componentExchange.getTarget();
            if (end.getPart() != null && end.getPart() instanceof Part) {
                parts.add((Part)end.getPart());
            }
        } else if (componentExchange.getTarget() instanceof Part) {
            parts.add((Part)componentExchange.getTarget());
        }
        return parts;
    }

    public static final boolean isEmpty(ExchangeLink functionalLink) {
        if (functionalLink.getExchanges() != null && !functionalLink.getExchanges().isEmpty()) {
            return false;
        }
        if (functionalLink.getSources() != null && !functionalLink.getSources().isEmpty()) {
            return false;
        }
        return functionalLink.getDestinations() == null || functionalLink.getDestinations().isEmpty();
    }

    public static final boolean isEmpty(ExchangeSpecification exchange) {
        return exchange.getSource() == null || exchange.getTarget() == null;
    }

    public static final boolean isLevelCoherent(ExchangeLink functionalLink) {
        if (FunctionalExt.isEmpty(functionalLink)) {
            return true;
        }
        HashSet<ExchangeLink> temp = new HashSet<ExchangeLink>();
        temp.add(functionalLink);
        temp.addAll((Collection<ExchangeLink>)functionalLink.getExchanges());
        temp.addAll((Collection<ExchangeLink>)functionalLink.getDestinations());
        temp.addAll((Collection<ExchangeLink>)functionalLink.getSources());
        ExchangeLink previous = functionalLink;
        for (EObject eObject : temp) {
            EObject currCont = eObject.eContainer();
            if (currCont == null) continue;
            if (currCont != previous) {
                return false;
            }
            previous = currCont;
        }
        return true;
    }

    public static EList<FunctionalExchange> getAllFunctionalExchanges(BlockArchitecture architecture) {
        BasicEList functionExchanges = new BasicEList();
        List<AbstractFunction> subFunctions = FunctionExt.getAllAbstractFunctions(architecture);
        for (AbstractFunction abstractFunction : subFunctions) {
            functionExchanges.addAll((Collection)abstractFunction.getOwnedFunctionalExchanges());
        }
        return functionExchanges;
    }

    public static Collection<FunctionalExchange> getFunctionalExchanges(ComponentPort port) {
        HashSet<FunctionalExchange> exchanges = new HashSet<FunctionalExchange>();
        for (ComponentExchange componentExchange : port.getComponentExchanges()) {
            exchanges.addAll((Collection<FunctionalExchange>)componentExchange.getAllocatedFunctionalExchanges());
        }
        return exchanges;
    }

    public static InformationsExchanger getOtherBound(ExchangeSpecification exchange, InformationsExchanger source) {
        if (exchange.getSource() == source) {
            return exchange.getTarget();
        }
        return exchange.getSource();
    }

    public static Collection<ComponentExchangeEnd> getRelatedComponentExchangeEnds(Part element) {
        ArrayList<ComponentExchangeEnd> result = new ArrayList<ComponentExchangeEnd>();
        ArrayList<EReference> refs = new ArrayList<EReference>();
        refs.add(FaPackage.Literals.COMPONENT_EXCHANGE_END__PART);
        for (Object objectRef : EObjectExt.getReferencers((EObject)element, refs)) {
            if (result.contains(objectRef)) continue;
            result.add((ComponentExchangeEnd)objectRef);
        }
        return result;
    }

    public static Collection<ComponentExchangeEnd> getRelatedComponentExchangeEnds(Port element) {
        ArrayList<ComponentExchangeEnd> result = new ArrayList<ComponentExchangeEnd>();
        ArrayList<EReference> refs = new ArrayList<EReference>();
        refs.add(FaPackage.Literals.COMPONENT_EXCHANGE_END__PORT);
        for (Object objectRef : EObjectExt.getReferencers((EObject)element, refs)) {
            if (result.contains(objectRef)) continue;
            result.add((ComponentExchangeEnd)objectRef);
        }
        return result;
    }
}

