/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.services.behaviors;

import org.polarsys.capella.common.ui.toolkit.services.behaviors.IInputBehavior;
import org.polarsys.capella.common.ui.toolkit.services.formats.IFormat;
import org.polarsys.capella.common.ui.toolkit.services.validators.RegExpValidator;

public abstract class AbstractInputBehavior
implements IInputBehavior {
    private RegExpValidator _validator = null;
    private IFormat _format = null;
    private String[] _defaultValues = null;

    protected AbstractInputBehavior(RegExpValidator validator, IFormat format) {
        this._validator = validator;
        this._format = format;
    }

    protected AbstractInputBehavior(RegExpValidator validator, IFormat format, String[] defaultValues) {
        this._validator = validator;
        this._format = format;
        this._defaultValues = defaultValues;
    }

    protected RegExpValidator getValidator() {
        return this._validator;
    }

    protected IFormat getFormat() {
        return this._format;
    }

    public String format(String input) {
        if (this._format == null || this._validator == null) {
            return input;
        }
        return this._format.format(input, this._validator.getPattern());
    }

    public boolean isValid(String value) {
        if (this._validator != null) {
            return this._validator.isValid(value) == null;
        }
        return false;
    }

    public String[] getDefaultValues() {
        return this._defaultValues;
    }

    public abstract Object getValue(String var1);
}

