/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.properties;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.internal.expressions.Property;
import org.eclipse.core.internal.expressions.TypeExtensionManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.menus.IMenuService;
import org.w3c.dom.Element;

public class PreferencesExpression
extends Expression {
    private String fNamespace;
    private String fProperty;
    private Object[] fArgs;
    private Object fExpectedValue;
    private boolean fForcePluginActivation;
    private static final char PROP_SEP = '.';
    private static final String ATT_PROPERTY = "property";
    private static final String ATT_ARGS = "args";
    private static final String ATT_FORCE_PLUGIN_ACTIVATION = "forcePluginActivation";
    private static final int HASH_INITIAL = PreferencesExpression.class.getName().hashCode();
    private static final TypeExtensionManager fgTypeExtensionManager = new TypeExtensionManager("preferenceTesters");

    public PreferencesExpression(IConfigurationElement element) throws CoreException {
        String property = element.getAttribute(ATT_PROPERTY);
        int pos = property.lastIndexOf(46);
        if (pos == -1) {
            throw new CoreException((IStatus)new ExpressionStatus(300, ExpressionMessages.TestExpression_no_name_space));
        }
        this.fNamespace = property.substring(0, pos);
        this.fProperty = property.substring(pos + 1);
        this.fArgs = Expressions.getArguments((IConfigurationElement)element, (String)ATT_ARGS);
        this.fExpectedValue = Expressions.convertArgument((String)element.getAttribute("value"));
        this.fForcePluginActivation = Expressions.getOptionalBooleanAttribute((IConfigurationElement)element, (String)ATT_FORCE_PLUGIN_ACTIVATION);
    }

    public PreferencesExpression(Element element) throws CoreException {
        String property = element.getAttribute(ATT_PROPERTY);
        int pos = property.lastIndexOf(46);
        if (pos == -1) {
            throw new CoreException((IStatus)new ExpressionStatus(300, ExpressionMessages.TestExpression_no_name_space));
        }
        this.fNamespace = property.substring(0, pos);
        this.fProperty = property.substring(pos + 1);
        this.fArgs = Expressions.getArguments((Element)element, (String)ATT_ARGS);
        String value = element.getAttribute("value");
        this.fExpectedValue = Expressions.convertArgument((String)(value.length() > 0 ? value : null));
        this.fForcePluginActivation = Expressions.getOptionalBooleanAttribute((Element)element, (String)ATT_FORCE_PLUGIN_ACTIVATION);
    }

    public PreferencesExpression(String namespace, String property, Object[] args, Object expectedValue) {
        this(namespace, property, args, expectedValue, false);
    }

    public PreferencesExpression(String namespace, String property, Object[] args, Object expectedValue, boolean forcePluginActivation) {
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull((Object)property);
        this.fNamespace = namespace;
        this.fProperty = property;
        this.fArgs = args != null ? args : Expressions.EMPTY_ARGS;
        this.fExpectedValue = expectedValue;
        this.fForcePluginActivation = forcePluginActivation;
    }

    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object element = context.getDefaultVariable();
        if (System.class.equals(element)) {
            String str = System.getProperty(this.fProperty);
            if (str == null) {
                return EvaluationResult.FALSE;
            }
            return EvaluationResult.valueOf((boolean)str.equals(this.fArgs[0]));
        }
        Property property = fgTypeExtensionManager.getProperty(element, this.fNamespace, this.fProperty, context.getAllowPluginActivation() && this.fForcePluginActivation);
        if (!property.isInstantiated()) {
            return EvaluationResult.NOT_LOADED;
        }
        return EvaluationResult.valueOf((boolean)property.test(element, this.fArgs, this.fExpectedValue));
    }

    public void collectExpressionInfo(ExpressionInfo info) {
        info.markDefaultVariableAccessed();
        info.addAccessedPropertyName(String.valueOf(this.fNamespace) + '.' + this.fProperty);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PreferencesExpression)) {
            return false;
        }
        PreferencesExpression that = (PreferencesExpression)((Object)object);
        return this.fNamespace.equals(that.fNamespace) && this.fProperty.equals(that.fProperty) && this.fForcePluginActivation == that.fForcePluginActivation && PreferencesExpression.equals((Object[])this.fArgs, (Object[])that.fArgs) && PreferencesExpression.equals((Object)this.fExpectedValue, (Object)that.fExpectedValue);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + PreferencesExpression.hashCode((Object[])this.fArgs) * 89 + PreferencesExpression.hashCode((Object)this.fExpectedValue) * 89 + this.fNamespace.hashCode() * 89 + this.fProperty.hashCode() * 89 + (this.fForcePluginActivation ? 1 : 0);
    }

    public String toString() {
        StringBuilder args = new StringBuilder();
        int i = 0;
        while (i < this.fArgs.length) {
            Object arg = this.fArgs[i];
            if (arg instanceof String) {
                args.append('\'');
                args.append(arg);
                args.append('\'');
            } else {
                args.append(arg.toString());
            }
            if (i < this.fArgs.length - 1) {
                args.append(", ");
            }
            ++i;
        }
        return "<test property=\"" + this.fProperty + (this.fArgs.length != 0 ? "\" args=\"" + args + "\"" : "\"") + (this.fExpectedValue != null ? "\" value=\"" + this.fExpectedValue + "\"" : "\"") + " plug-in activation: " + (this.fForcePluginActivation ? "eager" : "lazy") + "/>";
    }

    public boolean testGetForcePluginActivation() {
        return this.fForcePluginActivation;
    }

    public static TypeExtensionManager testGetTypeExtensionManager() {
        return fgTypeExtensionManager;
    }

    public void showhideMenuContribution() {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = activitySupport.getActivityManager();
        IActivity a = activityManager.getActivity("org.eclipse.ui.actions");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IMenuService mSvc = (IMenuService)window.getService(IMenuService.class);
        ISelection selection = window.getSelectionService().getSelection("capella.project.explorer");
        ((TreeSelection)selection).getFirstElement();
    }
}

