/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.service.IFieldEditorPropertyPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.IPropertyPersistentPreferenceStore;
import org.polarsys.capella.core.commands.preferences.service.PropertyStore;
import org.polarsys.capella.core.preferences.Activator;

public abstract class FieldEditorPropertyPreferencePage
extends FieldEditorPreferencePage
implements IFieldEditorPropertyPreferencePage,
IWorkbenchPropertyPage {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    public static final String USEPROJECTSETTINGS = "useProjectSettings";
    private static final String TRUE = "true";
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private static Set<String> propertyPagesIdentifients = new HashSet<String>();
    private IAdaptable element;
    private IPreferenceStore propertiesStore;
    private ImageDescriptor image;
    private String pageId;

    public FieldEditorPropertyPreferencePage(int style) {
        super(style);
    }

    public FieldEditorPropertyPreferencePage(String title, int style) {
        super(title, style);
    }

    public FieldEditorPropertyPreferencePage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
        this.image = image;
    }

    protected abstract String getPageId();

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public boolean isPropertyPage() {
        return this.getElement() != null && this.getElement() instanceof IResource;
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            this.pageId = this.getPageId();
            this.propertiesStore = new PropertyStore((IResource)this.getElement(), Activator.getDefault().getPreferenceStore(), this.pageId);
        }
        super.createControl(parent);
        if (this.isPropertyPage()) {
            this.updateFieldEditors();
        }
    }

    protected Control createContents(Composite parent) {
        this.isPropertyPage();
        return super.createContents(parent);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.isPropertyPage()) {
            return this.propertiesStore;
        }
        return super.getPreferenceStore();
    }

    private void updateFieldEditors() {
        Activator.getDefault().setPropertyStore((IResource)this.getElement(), this.propertiesStore);
        ((IPropertyPersistentPreferenceStore)this.propertiesStore).initilizeGuestListeners();
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.setEnabled(enabled, parent);
        }
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.isPropertyPage()) {
            IResource resource = (IResource)this.getElement();
            try {
                resource.setPersistentProperty(new QualifiedName(this.pageId, USEPROJECTSETTINGS), TRUE);
                resource.getPersistentProperty(new QualifiedName(this.pageId, USEPROJECTSETTINGS));
                if (this.propertiesStore != null && this.propertiesStore instanceof IPropertyPersistentPreferenceStore) {
                    try {
                        ((IPropertyPersistentPreferenceStore)this.propertiesStore).save();
                    }
                    catch (IOException exception_p) {
                        StringBuilder loggerMessage = new StringBuilder("FieldEditorPropertyPreferencePage.performOk(..) _ ");
                        __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected void performDefaults() {
        this.isPropertyPage();
        super.performDefaults();
    }

    public boolean performCancel() {
        if (this.propertiesStore != null) {
            ((PropertyStore)this.propertiesStore).setCanceled(true);
        }
        return false;
    }

    protected void configureWorkspaceSettings() {
        try {
            IPreferencePage page = (IPreferencePage)this.getClass().newInstance();
            page.setTitle(this.getTitle());
            page.setImageDescriptor(this.image);
            this.showPreferencePage(this.pageId, page);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            {
                this.val$targetNode = iPreferenceNode;
            }

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                dialog.open();
            }
        });
    }

    public static Set<String> getPropertyPagesIdentifients() {
        return propertyPagesIdentifients;
    }

    public void setPropertyPagesIdentifients(Set<String> propertyPagesIdentifients_p) {
        propertyPagesIdentifients = propertyPagesIdentifients_p;
    }
}

