/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.la.validation.logicalActor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.SystemActorRealization;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_LogicalActor_ActorRealization
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof LogicalActor) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            LogicalActor actor = (LogicalActor)eObj;
            EList traces = actor.getOutgoingTraces();
            if (traces.size() < 1) {
                return ctx_p.createSuccessStatus();
            }
            for (AbstractTrace next : traces) {
                TraceableElement sourceElement;
                if (!(next instanceof SystemActorRealization)) continue;
                TraceableElement targetElement = next.getTargetElement();
                if (targetElement == null || !(targetElement instanceof Actor)) {
                    statuses.add(ctx_p.createFailureStatus(new Object[]{String.valueOf(actor.getName()) + " (" + actor.eClass().getName() + ") contain realization with inconsistent Target (it should be System Actor)."}));
                }
                if ((sourceElement = next.getSourceElement()) != null && sourceElement instanceof LogicalActor) continue;
                statuses.add(ctx_p.createFailureStatus(new Object[]{String.valueOf(actor.getName()) + " (" + actor.eClass().getName() + ") contain realization with inconsistent Source (it should be Logical Actor)."}));
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
            }
        }
        return ctx_p.createSuccessStatus();
    }
}

