/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.framework.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractContextMenuFiller;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.ShowInDiagramAction;
import org.polarsys.capella.core.refinement.framework.ui.IValidator;
import org.polarsys.capella.core.refinement.framework.ui.Messages;
import org.polarsys.capella.core.refinement.framework.ui.SelectionContentProvider;
import org.polarsys.capella.core.refinement.framework.ui.SelectionLabelProvider;
import org.polarsys.capella.core.refinement.framework.ui.SelectionWizard;
import org.polarsys.capella.core.refinement.framework.ui.model.ComponentSelectionItem;
import org.polarsys.capella.core.refinement.framework.ui.model.SelectionItemNode;
import org.polarsys.capella.core.refinement.framework.ui.model.TargetSelectionItem;

public class SelectionPage
extends WizardPage
implements ICheckStateListener {
    private String _nameLabel;
    private boolean _isMultipleSelection = false;
    private boolean _autoSelectChild = false;
    private boolean _selectAllByDefault = false;
    private boolean _showNameTextField = false;
    private boolean _isAmbiguityResolutionPage = false;
    private SelectionItemNode _root = null;
    private Button _selectAll = null;
    private Button _deselectAll = null;
    private Label _nameLbl = null;
    private Text _nameTxt = null;
    private Text _statusBar = null;
    protected CheckboxTreeViewer _tree = null;
    private AbstractContextMenuFiller _contextMenuManagerFiller;

    public SelectionPage(SelectionItemNode root, String title, String description, boolean isMultipleSelection, boolean autoSelectChild, boolean selectAllByDefault, boolean showNameTextField, String nameLabel, boolean isAmbiguityResolutionPage) {
        super("wizardPage");
        this._root = root;
        this._nameLabel = nameLabel;
        this._isMultipleSelection = isMultipleSelection;
        this._autoSelectChild = autoSelectChild;
        this._selectAllByDefault = selectAllByDefault;
        this._showNameTextField = showNameTextField;
        this._isAmbiguityResolutionPage = isAmbiguityResolutionPage;
        this.setTitle(title);
        this.setDescription(description);
    }

    public SelectionPage(SelectionItemNode root, String title, String description, boolean isMultipleSelection, boolean autoSelectChild) {
        this(root, title, description, isMultipleSelection, autoSelectChild, false, false, "", false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData layoutData = null;
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.verticalSpacing = 4;
        container.setLayout((Layout)layout);
        if (this._showNameTextField) {
            this._nameLbl = new Label(container, 0);
            this._nameLbl.setText(this._nameLabel);
            layoutData = new GridData();
            layoutData.horizontalSpan = 1;
            this._nameLbl.setLayoutData((Object)layoutData);
            this._nameTxt = new Text(container, 2048);
            layoutData = new GridData();
            layoutData.horizontalAlignment = 4;
            layoutData.horizontalSpan = 3;
            this._nameTxt.setLayoutData((Object)layoutData);
            this._nameTxt.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectionPage.this.validatePage();
                }
            });
        }
        this._tree = new CheckboxTreeViewer(container);
        this._tree.setContentProvider((IContentProvider)new SelectionContentProvider());
        this._tree.setLabelProvider((IBaseLabelProvider)new SelectionLabelProvider());
        this._tree.setUseHashlookup(true);
        this._contextMenuManagerFiller = new AbstractContextMenuFiller(){

            public void fillMenuManager(IMenuManager contextMenuManager, final ISelection selection) {
                final LocateInCapellaExplorerAction selectInExplorerAction = new LocateInCapellaExplorerAction(){

                    protected ISelection getSelection() {
                        return selection;
                    }

                    protected Object getFirstSelectedElement(ISelection selection2) {
                        Object selectedObj = super.getFirstSelectedElement(selection2);
                        if (selectedObj instanceof SelectionItemNode) {
                            return ((SelectionItemNode)selectedObj).getData();
                        }
                        return selectedObj;
                    }
                };
                Action showInBrowserAction = new Action(){

                    public void run() {
                        selectInExplorerAction.run((IAction)this);
                    }
                };
                selectInExplorerAction.shouldIgnoreWorkbenchPartSite(true);
                showInBrowserAction.setText("Show in Capella Explorer");
                showInBrowserAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("capella_16.png"));
                selectInExplorerAction.selectionChanged((IAction)showInBrowserAction, selection);
                if (showInBrowserAction.isEnabled()) {
                    contextMenuManager.add((IAction)showInBrowserAction);
                }
                ShowInDiagramAction showInDiagramAction = new ShowInDiagramAction(){

                    private Object getFirstSelectedElement(IStructuredSelection selection2) {
                        Object selectedObj = selection2.getFirstElement();
                        if (selectedObj instanceof SelectionItemNode) {
                            return ((SelectionItemNode)selectedObj).getData();
                        }
                        return selectedObj;
                    }

                    public IStructuredSelection getStructuredSelection() {
                        Object selectedObj = this.getFirstSelectedElement((IStructuredSelection)selection);
                        return new StructuredSelection(selectedObj);
                    }

                    protected boolean updateSelection(IStructuredSelection selection2) {
                        Object selectedObj = this.getFirstSelectedElement(selection2);
                        return super.updateSelection((IStructuredSelection)new StructuredSelection(selectedObj));
                    }
                };
                showInDiagramAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("showInDiagram.gif"));
                showInDiagramAction.selectionChanged(showInDiagramAction.getStructuredSelection());
                if (showInDiagramAction.isEnabled()) {
                    contextMenuManager.add((IAction)showInDiagramAction);
                }
            }
        };
        Control control = this._tree.getControl();
        final MenuManager _contextMenuManager = new MenuManager("#Popup");
        _contextMenuManager.setRemoveAllWhenShown(true);
        _contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (SelectionPage.this._contextMenuManagerFiller != null) {
                    SelectionPage.this._contextMenuManagerFiller.fillMenuManager((IMenuManager)_contextMenuManager, SelectionPage.this._tree.getSelection());
                }
            }
        });
        Menu _contextMenu = _contextMenuManager.createContextMenu(control);
        control.setMenu(_contextMenu);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.horizontalSpan = 4;
        layoutData.verticalAlignment = 4;
        layoutData.verticalSpan = 2;
        this._tree.getControl().setLayoutData((Object)layoutData);
        this._tree.setInput((Object)this._root);
        this._tree.expandAll();
        this._tree.setAllChecked(this._selectAllByDefault);
        this._tree.addCheckStateListener((ICheckStateListener)this);
        this._tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ContentViewer source;
                ILabelProvider labelProvider;
                if (SelectionPage.this._statusBar != null && (labelProvider = (ILabelProvider)(source = (ContentViewer)event.getSource()).getLabelProvider()) instanceof SelectionLabelProvider) {
                    SelectionLabelProvider prov = (SelectionLabelProvider)labelProvider;
                    SelectionPage.this._statusBar.setText(prov.getExtendedText(event.getSelection()));
                }
            }
        });
        if (this._isMultipleSelection) {
            this._selectAll = new Button(container, 8);
            this._selectAll.setText(Messages.getString("SelectionPage.1"));
            this._selectAll.setSize(100, 20);
            layoutData = new GridData();
            layoutData.grabExcessVerticalSpace = true;
            layoutData.horizontalAlignment = 4;
            layoutData.verticalAlignment = 3;
            this._selectAll.setLayoutData((Object)layoutData);
            this._selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Object obj;
                    Object[] objectArray = SelectionPage.this._tree.getCheckedElements();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        obj = objectArray[n2];
                        SelectionPage.this._tree.setChecked(obj, false);
                        ++n2;
                    }
                    objectArray = SelectionPage.this._tree.getGrayedElements();
                    n = objectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        obj = objectArray[n2];
                        SelectionPage.this._tree.setGrayChecked(obj, false);
                        ++n2;
                    }
                    SelectionPage.this._tree.setAllChecked(true);
                    SelectionPage.this.validatePage();
                }
            });
            this._deselectAll = new Button(container, 8);
            this._deselectAll.setText(Messages.getString("SelectionPage.2"));
            layoutData = new GridData();
            layoutData.grabExcessVerticalSpace = true;
            layoutData.horizontalAlignment = 4;
            layoutData.verticalAlignment = 1;
            this._deselectAll.setLayoutData((Object)layoutData);
            this._deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelectionPage.this._tree.setAllChecked(false);
                    SelectionPage.this.validatePage();
                }
            });
        }
        this._statusBar = new Text(container, 2056);
        this._statusBar.setEditable(false);
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalSpan = 4;
        this._statusBar.setLayoutData((Object)layoutData);
        this.setControl((Control)container);
    }

    public List<SelectionItemNode> getSelection() {
        ArrayList<SelectionItemNode> list = new ArrayList<SelectionItemNode>();
        Object[] objectArray = this._tree.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            list.add((SelectionItemNode)obj);
            ++n2;
        }
        return list;
    }

    public String getNameValue() {
        if (this._showNameTextField) {
            return this._nameTxt.getText();
        }
        return null;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this._isMultipleSelection && this._autoSelectChild) {
            boolean isChecked = event.getChecked();
            TargetSelectionItem item = (TargetSelectionItem)event.getElement();
            TargetSelectionItem parent = (TargetSelectionItem)item.getParent();
            item.setIsChecked(isChecked);
            this._tree.setSubtreeChecked((Object)item, isChecked);
            this._tree.setGrayChecked((Object)item, false);
            this._tree.setChecked((Object)item, isChecked);
            if (parent.hasAllChildrenChecked()) {
                this._tree.setGrayChecked((Object)parent, false);
                this._tree.setChecked((Object)parent, true);
            } else if (parent.hasChildrenChecked()) {
                this._tree.setGrayChecked((Object)parent, true);
            } else {
                this._tree.setChecked((Object)parent, false);
            }
        }
        this.validatePage();
    }

    protected boolean validatePage() {
        boolean bRes = true;
        SelectionWizard wizard = (SelectionWizard)this.getWizard();
        if (wizard != null) {
            for (IValidator validator : wizard.getValidators()) {
                if (validator.isValid(this)) continue;
                this.setMessage(validator.getMessage(), 3);
                bRes = false;
                break;
            }
        }
        if (this.getSelection().isEmpty()) {
            this.setMessage(Messages.getString("SelectionPage.3"), 3);
            bRes = false;
        } else if (!this._isMultipleSelection && this.getSelection().size() != 1) {
            this.setMessage(Messages.getString("SelectionPage.4"), 3);
            bRes = false;
        } else if (this._showNameTextField && this.getNameValue().equals("")) {
            this.setMessage(Messages.getString("SelectionPage.5"), 3);
            bRes = false;
        }
        if (this._isAmbiguityResolutionPage && this.getSelection().size() > 0 && this.getSelection().get(0) instanceof ComponentSelectionItem) {
            if (((ComponentSelectionItem)this.getSelection().get(0)).getData() instanceof Scenario) {
                this.setMessage(Messages.getString("SelectionPage.6"), 3);
                bRes = false;
            } else if (((ComponentSelectionItem)this.getSelection().get(0)).getData() instanceof SequenceMessage) {
                this.setMessage(Messages.getString("SelectionPage.7"), 3);
                bRes = false;
            }
        }
        if (bRes) {
            this.setMessage(null);
        }
        return bRes;
    }
}

