/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.functionPort;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPortExt;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class FP05_FunctionPort_OwningFunction
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof FunctionPort) {
            AbstractFunction owner = (AbstractFunction)eObj.eContainer();
            for (Port fip : FunctionPortExt.getRealizingPorts((FunctionPort)((FunctionPort)eObj))) {
                AbstractFunction fct = (AbstractFunction)fip.eContainer();
                if (FunctionExt.getRealizedFunctions((AbstractFunction)fct).contains(owner)) continue;
                return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)fct, Arrays.asList(fct, owner), (String)this.getMessagePattern(), (Object[])new Object[]{owner.getName(), fct.getName()});
            }
        }
        return ctx.createSuccessStatus();
    }

    protected String getMessagePattern() {
        return "{0} (Function} shall be realized by {1} (Function} : both contain a function port having a realization link between them";
    }
}

