/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.functionalChainInvolvement;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class FunctionalChainInvolvement_ExchangeItems
extends AbstractValidationRule {
    private static final String EXCHANGE_ITEMS_NAMES_LIST_SEPARATOR = new String(new char[]{'L'});

    public IStatus validate(IValidationContext ctx) {
        EMFEventType eType = ctx.getEventType();
        if (EMFEventType.NULL != eType) {
            return ctx.createSuccessStatus();
        }
        EObject eObj = ctx.getTarget();
        if (!(eObj instanceof FunctionalChainInvolvement)) {
            return ctx.createSuccessStatus();
        }
        FunctionalChainInvolvement element = (FunctionalChainInvolvement)eObj;
        if (!(element.getInvolved() instanceof FunctionalExchange)) {
            return ctx.createSuccessStatus();
        }
        Collection invalidExchangeItems = FunctionalChainExt.getInvalidExchangeItems((FunctionalChainInvolvement)element);
        if (!invalidExchangeItems.isEmpty()) {
            ArrayList<String> invalidExchangeItemsNames = new ArrayList<String>(invalidExchangeItems.size());
            for (AbstractExchangeItem abstractExchangeItem : invalidExchangeItems) {
                invalidExchangeItemsNames.add(abstractExchangeItem.getName());
            }
            return ctx.createFailureStatus(new Object[]{EObjectLabelProviderHelper.getText((EObject)element), StringUtils.join(invalidExchangeItemsNames, (String)EXCHANGE_ITEMS_NAMES_LIST_SEPARATOR), invalidExchangeItemsNames.size() > 1 ? "are" : "is"});
        }
        return ctx.createSuccessStatus();
    }
}

