/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext.sections;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.TextAreaValueGroup;
import org.polarsys.capella.core.ui.properties.richtext.RichtextManager;
import org.polarsys.capella.core.ui.properties.richtext.fields.CapellaElementDescriptionGroup;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;

public class CapellaDescriptionPropertySection
extends AbstractSection {
    private static Map<CapellaDescriptionPropertySection, EObject> mapDescriptionSectionToEObject = new HashMap<CapellaDescriptionPropertySection, EObject>();
    protected CapellaElementDescriptionGroup descriptionGroup;
    private TextAreaValueGroup descriptionFallbackGroup;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.rootParentComposite.setLayout((Layout)new GridLayout());
        this.rootParentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        if (RichtextManager.getInstance().isRichTextEnabled()) {
            this.descriptionGroup = new CapellaElementDescriptionGroup(this.rootParentComposite, aTabbedPropertySheetPage != null ? this.getWidgetFactory() : null, (ISection)this);
        } else {
            this.descriptionFallbackGroup = new TextAreaValueGroup(this.rootParentComposite, "", this.getWidgetFactory(), true);
            this.descriptionFallbackGroup.setDisplayedInWizard(this.isDisplayedInWizard());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.descriptionGroup != null) {
            this.descriptionGroup.dispose();
            this.descriptionGroup = null;
        }
        mapDescriptionSectionToEObject.remove((Object)this);
        if (this.isDisplayedInWizard()) {
            Set<CapellaDescriptionPropertySection> availableDescriptionSections = mapDescriptionSectionToEObject.keySet();
            for (CapellaDescriptionPropertySection descriptionSection : availableDescriptionSections) {
                if (descriptionSection == null || descriptionSection.isDisplayedInWizard()) continue;
                descriptionSection.refresh();
                descriptionSection.aboutToBeShown();
            }
        }
    }

    protected void handleParentBackground(Color color, Composite parent) {
    }

    public void aboutToBeHidden() {
        if (this.descriptionGroup != null) {
            this.descriptionGroup.aboutToBeHidden();
        }
        super.aboutToBeHidden();
    }

    public void aboutToBeShown() {
        if (this.descriptionGroup != null) {
            this.descriptionGroup.aboutToBeShown();
        }
        super.aboutToBeShown();
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        mapDescriptionSectionToEObject.put(this, capellaElement);
        if (this.descriptionGroup != null) {
            this.descriptionGroup.loadData(capellaElement);
        } else if (this.descriptionFallbackGroup != null) {
            this.descriptionFallbackGroup.loadData(capellaElement, (EStructuralFeature)CapellacorePackage.eINSTANCE.getCapellaElement_Description());
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject elt;
        if (selection instanceof StructuredSelection && (elt = CapellaAdapterHelper.resolveSemanticObject((Object)((StructuredSelection)selection).getFirstElement())) instanceof CapellaElement) {
            AbstractType type;
            boolean allowMultiplePart;
            if (elt.eClass().equals(CsPackage.eINSTANCE.getPart()) && !(allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)((Part)elt)))) && (type = ((Part)elt).getAbstractType()) != null && !(type instanceof ConfigurationItem)) {
                super.setInput(part, (ISelection)new StructuredSelection((Object)type));
                this.loadData((EObject)((CapellaElement)type));
                return;
            }
            this.loadData((EObject)((CapellaElement)elt));
        }
        super.setInput(part, selection);
    }

    public boolean select(Object toTest) {
        EObject eObj = CapellaAdapterHelper.resolveSemanticObject((Object)toTest);
        return eObj instanceof CapellaElement;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.descriptionGroup != null) {
            this.descriptionGroup.setEnabled(enabled);
        }
    }

    public List<AbstractSemanticField> getSemanticFields() {
        if (this.descriptionFallbackGroup != null) {
            return Collections.singletonList(this.descriptionFallbackGroup);
        }
        return Collections.emptyList();
    }

    public void refresh() {
        if (this.shouldRefresh()) {
            super.refresh();
        }
    }

    public boolean shouldRefresh() {
        return this.descriptionGroup == null || this.descriptionGroup.shouldRefresh();
    }
}

