/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.extendedqueries.information;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.business.abstractqueries.helpers.CapellaElementsHelperForBusinessQueries;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.queries.filters.RemoveUnnamedElementFilter;
import org.polarsys.capella.core.queries.helpers.QueryExt;

public class GetAvailable_Generic_ReferencedProperty__Lib
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        List parameters = (List)input;
        CapellaElement element = (CapellaElement)parameters.get(0);
        List types = (List)parameters.get(1);
        ArrayList<Object> result = new ArrayList();
        BlockArchitecture blockArchitectureInProject = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)element);
        for (IModel library : LibraryManagerExt.getAllActivesReferences((IModel)currentProject)) {
            BlockArchitecture blockArchitecture = QueryExt.getCorrespondingBlockArchitectureFromLibrary((BlockArchitecture)blockArchitectureInProject, (CapellaModel)((CapellaModel)library));
            for (BlockArchitecture currentBlockArchitecture : BlockArchitectureExt.getAllAllocatedArchitectures((BlockArchitecture)blockArchitecture)) {
                DataPkg dataPkg = currentBlockArchitecture.getOwnedDataPkg();
                if (dataPkg == null) continue;
                result.addAll(this.getDataFromLevel(dataPkg, element, types));
            }
        }
        result = QueryInterpretor.executeFilter(result, (IQueryFilter)new RemoveUnnamedElementFilter());
        return result;
    }

    public List<CapellaElement> getDataFromLevel(DataPkg dataPkg, CapellaElement capellaElement, List<EClass> types) {
        if (capellaElement instanceof DataValue) {
            DataValue dataValue = (DataValue)capellaElement;
            AbstractType type = dataValue.getAbstractType();
            if (type != null && type instanceof GeneralizableElement) {
                List list = CapellaElementsHelperForBusinessQueries.getPropertiesTypedBy((DataPkg)dataPkg, (GeneralizableElement)((GeneralizableElement)type), (boolean)false);
                ArrayList<CapellaElement> returnValue = new ArrayList<CapellaElement>();
                for (CapellaElement element : list) {
                    Type propertyType;
                    if (!(element instanceof Property) || !CapellaElementsHelperForBusinessQueries.canBeInstanciatedAs((EObject)(propertyType = ((Property)element).getType()), types)) continue;
                    returnValue.add(element);
                }
                return returnValue;
            }
            return CapellaElementsHelperForBusinessQueries.getPropertiesTypedBy((DataPkg)dataPkg, null, (boolean)true);
        }
        return Collections.emptyList();
    }
}

