/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.internal.interpreter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.internal.interpreter.FeatureInterpreter;
import org.eclipse.sirius.common.ui.Messages;

public class FeatureProposalProvider
implements IProposalProvider {
    protected static final String SEPARATOR_1 = ":";
    protected static final String SEPARATOR_2 = " - ";

    public ContentProposal getNewEmtpyExpression() {
        return new ContentProposal("feature:", "feature:", Messages.FeatureProposalProvider_newFeatureExpression, "feature:".length());
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        List<Object> proposals;
        if (context == null || !(interpreter instanceof FeatureInterpreter) && interpreter != null) {
            proposals = Collections.emptyList();
        } else if ((context.getContents() == null || context.getContents().length() == 0) && this.isPrefixUsed()) {
            proposals = Collections.singletonList(this.getNewEmtpyExpression());
        } else {
            LinkedHashSet intersectingProposals = null;
            IInterpreterContext interpreterContext = context.getInterpreterContext();
            for (TypeName type : interpreterContext.getTargetType().getPossibleTypes()) {
                for (EClass possibleEClass : Iterables.filter((Iterable)type.search(interpreterContext.getAvailableEPackages()), EClass.class)) {
                    LinkedHashSet proposalsForThisType = Sets.newLinkedHashSet(this.getProposals(context.getContents(), context.getPosition(), possibleEClass, this.getExpectedFeatureType(interpreterContext)));
                    intersectingProposals = intersectingProposals == null ? proposalsForThisType : Sets.intersection((Set)intersectingProposals, (Set)proposalsForThisType);
                }
            }
            proposals = intersectingProposals != null ? new ArrayList<ContentProposal>(intersectingProposals) : Collections.emptyList();
        }
        return proposals;
    }

    protected boolean isPrefixUsed() {
        return false;
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        List<ContentProposal> proposals = context == null || !(interpreter instanceof FeatureInterpreter) ? Collections.emptyList() : (context.getCurrentSelected() == null ? Collections.singletonList(this.getNewEmtpyExpression()) : this.getProposals(context.getTextSoFar(), context.getCursorPosition(), context.getCurrentSelected().eClass(), Collections.emptyList()));
        return proposals;
    }

    private List<ContentProposal> getProposals(String writtenExpression, int cursorPosition, EClass currentElementType, Collection<EClass> featureTypes) {
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        String featureNameWithPrefix = writtenExpression.substring(0, cursorPosition);
        String userInput = this.getContentWithoutPrefix(featureNameWithPrefix = featureNameWithPrefix.trim());
        if (userInput != null) {
            List<ContentProposal> newComputedFeatures = this.addComputedFeatures(userInput);
            if (newComputedFeatures != null) {
                proposals.addAll(newComputedFeatures);
            }
            if (currentElementType != null) {
                for (EStructuralFeature eStructuralFeature : currentElementType.getEAllStructuralFeatures()) {
                    if (!this.correctEType(eStructuralFeature, featureTypes) || !eStructuralFeature.getName().startsWith(userInput)) continue;
                    String displayedName = String.valueOf(eStructuralFeature.getName()) + (eStructuralFeature.isMany() ? "[" + eStructuralFeature.getLowerBound() + ".." + (eStructuralFeature.getUpperBound() == -1 ? "*" : Integer.valueOf(eStructuralFeature.getUpperBound())) + "]" : "") + (eStructuralFeature.getEType() != null ? SEPARATOR_1 + eStructuralFeature.getEType().getName() : "") + SEPARATOR_2 + eStructuralFeature.getEContainingClass().getName();
                    proposals.add(new ContentProposal(eStructuralFeature.getName(), displayedName, displayedName));
                }
            }
        }
        return proposals;
    }

    private boolean correctEType(EStructuralFeature eStructuralFeature, Collection<EClass> featureTypes) {
        boolean value = true;
        if (!featureTypes.isEmpty()) {
            EClassifier eType = eStructuralFeature.getEType();
            value = eType instanceof EClass ? featureTypes.stream().filter(featureType -> ((EClass)eType).isSuperTypeOf(featureType)).findFirst().isPresent() : false;
        }
        return value;
    }

    protected String getContentWithoutPrefix(String featureNameWithPrefix) {
        return featureNameWithPrefix;
    }

    protected List<ContentProposal> addComputedFeatures(String userInput) {
        return new ArrayList<ContentProposal>(0);
    }

    protected Collection<EClass> getExpectedFeatureType(IInterpreterContext context) {
        return Collections.emptyList();
    }
}

