/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ui.actions.ModelAdaptation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class ActionPropertyTester
extends PropertyTester {
    public boolean test(Object object_p, String propertyName_p, Object[] params_p, Object testedValue_p) {
        ModelElement element;
        boolean result = false;
        if ((propertyName_p.equals("actionMode") || propertyName_p.equals("graphicalActionMode")) && (element = ModelAdaptation.adaptToCapella((Object)object_p)) != null && element instanceof CapellaElement) {
            String actionName = (String)testedValue_p;
            if ("propagationEIOnPorts".equals(actionName)) {
                return this.isPropagationEIOnPorts(element);
            }
            if ("synchronizeEIOnPorts".equals(actionName)) {
                return this.isSynchronizeEIOnPorts(element);
            }
            if ("propagationPortRealizationsFromFE".equals(actionName)) {
                return this.isPropagationPortRealizationsFromFE(element);
            }
            if ("propagationPortRealizationsFromCE".equals(actionName)) {
                return this.isPropagationPortRealizationsFromCE(element);
            }
            if ("convertClassPrimitive".equals(actionName)) {
                return this.isConvertPrimitive(element);
            }
            if ("transformLiteralNumericValue".equals(actionName)) {
                return element instanceof LiteralNumericValue;
            }
            if ("requirementManagerWizard".equals(actionName)) {
                return this.isRequirementManagerWizard(element);
            }
            if ("traceManager".equals(actionName)) {
                return this.isTraceManager(element);
            }
            if ("allocationManagement".equals(actionName)) {
                return this.isAllocationManagement(element);
            }
            if ("copyPath".equals(actionName)) {
                return this.isCopyPath(element);
            }
        }
        return result;
    }

    private boolean isCopyPath(ModelElement element) {
        return true;
    }

    private boolean isAllocationManagement(ModelElement element) {
        return true;
    }

    private boolean isTraceManager(ModelElement element) {
        return true;
    }

    private boolean isRequirementManagerWizard(ModelElement element) {
        return true;
    }

    private boolean isConvertPrimitive(ModelElement element) {
        if (element instanceof Class) {
            Class cl = (Class)element;
            return cl.isIsPrimitive();
        }
        return false;
    }

    private boolean isPropagationPortRealizationsFromCE(ModelElement element_p) {
        ModelElement element = element_p;
        boolean result = false;
        if (element instanceof ComponentExchange) {
            result = true;
        }
        if (element instanceof Part) {
            element = ((Part)element).getAbstractType();
        }
        if (element instanceof Component && !(element instanceof ConfigurationItem) && !(element instanceof ComponentContext)) {
            result = true;
        }
        if (result) {
            result = !CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element_p));
        }
        return result;
    }

    private boolean isPropagationPortRealizationsFromFE(ModelElement element_p) {
        boolean result = false;
        result = element_p instanceof AbstractFunction || element_p instanceof FunctionalExchange;
        result = result && !CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element_p));
        return result;
    }

    private boolean isPropagationEIOnPorts(ModelElement element_p) {
        boolean result = element_p instanceof CapellaElement;
        result = element_p instanceof AbstractFunction || element_p instanceof FunctionalExchange;
        result = result && !CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element_p));
        return result;
    }

    private boolean isSynchronizeEIOnPorts(ModelElement element) {
        boolean result = element instanceof FunctionalExchange;
        result = result && !CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element));
        return result;
    }
}

