/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.policies.match;

import java.util.HashSet;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityTraceHandler;
import org.polarsys.capella.core.transition.common.merge.scope.TargetModelScope;
import org.polarsys.capella.core.transition.common.policies.match.TraceabilityHandlerMatchPolicy;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class TopDownMatchPolicy
extends TraceabilityHandlerMatchPolicy {
    public TopDownMatchPolicy(IContext context2) {
        super(context2);
    }

    public Comparable<?> getMatchID(EObject element, IModelScope scope) {
        ITraceabilityTraceHandler tHandler;
        Object bound = null;
        IContext context = this.getContext();
        ITraceabilityHandler sourceHandler = (ITraceabilityHandler)context.get((Object)"TSMH");
        ITraceabilityHandler targetHandler = (ITraceabilityHandler)context.get((Object)"TTMH");
        ITraceabilityHandler handler = null;
        handler = scope instanceof TargetModelScope ? targetHandler : sourceHandler;
        context.put((Object)"TH", (Object)handler);
        String ID = null;
        if (handler instanceof ITraceabilityTraceHandler && (tHandler = (ITraceabilityTraceHandler)handler).isTrace(element, context)) {
            ID = this.getTraceIdentifier(element, context, scope, tHandler);
        }
        if (ID == null) {
            ID = this.getIdentifier(element, context, scope, handler);
        }
        if (ID == null) {
            ID = handler.getId(element, context);
        }
        return ID;
    }

    private String getTraceIdentifier(EObject element, IContext context, IModelScope scope, ITraceabilityTraceHandler handler) {
        IContext icontext = this.getContext();
        String ID = "";
        EObject target = handler.getTargetElement(element, icontext);
        EObject source = handler.getSourceElement(element, icontext);
        if (target != null && source != null) {
            ID = "TRACE_BETWEEN_" + this.getMatchID(target, scope) + " " + this.getMatchID(source, scope) + " " + element.eClass().getName();
        }
        return ID;
    }

    private String getIdentifier(EObject element, IContext context, IModelScope scope, ITraceabilityHandler handler) {
        BlockArchitecture elementArch;
        String ID = "";
        if (element == null) {
            return ID;
        }
        if (element.eClass() == null) {
            return ID;
        }
        if (!this.isMatchable(element, scope, context)) {
            ID = String.valueOf(ID) + "UNMATCHABLE-ELEMENT-";
        }
        if ((elementArch = BlockArchitectureExt.getRootBlockArchitecture((EObject)element)) != null) {
            ID = String.valueOf(ID) + elementArch.eClass().getName() + "_";
        }
        EObject sourceElement = element;
        String relationBetweenElements = element.eClass().getName();
        HashSet sources = handler.retrieveSourceElements(element, context);
        if (sources.isEmpty()) {
            FunctionInputPort port;
            if (element instanceof FunctionInputPort) {
                port = (FunctionInputPort)element;
                sources = new HashSet();
                for (FunctionalExchange exchange : port.getIncomingFunctionalExchanges()) {
                    sources.addAll(handler.retrieveSourceElements((EObject)exchange, context));
                }
            }
            if (element instanceof FunctionOutputPort) {
                port = (FunctionOutputPort)element;
                sources = new HashSet();
                for (FunctionalExchange exchange : port.getOutgoingFunctionalExchanges()) {
                    sources.addAll(handler.retrieveSourceElements((EObject)exchange, context));
                }
            }
            if (element instanceof ComponentPort) {
                port = (ComponentPort)element;
                sources = new HashSet();
                for (FunctionalExchange exchange : port.getComponentExchanges()) {
                    relationBetweenElements = port.equals(ComponentExchangeExt.getSourcePort((ComponentExchange)exchange)) ? "sourceOf" : "targetOf";
                    sources.addAll(handler.retrieveSourceElements((EObject)exchange, context));
                }
            }
        }
        if (!sources.isEmpty()) {
            sourceElement = (EObject)sources.iterator().next();
        }
        if (sourceElement != null) {
            String sourceElementId = handler.getId(sourceElement, context);
            if (!this.isUnique(element)) {
                ID = String.valueOf(ID) + sourceElementId;
                ID = String.valueOf(ID) + relationBetweenElements;
                ID = String.valueOf(ID) + sourceElement.eClass().getName();
            }
        }
        ID = String.valueOf(ID) + element.eClass().getName();
        if (sourceElement instanceof ActivityAllocation && element instanceof ComponentFunctionalAllocation) {
            ID = String.valueOf(ID) + this.getIdentifier((EObject)((ComponentFunctionalAllocation)element).getSourceElement(), context, scope, handler);
        }
        return ID;
    }

    protected boolean isUnique(EObject element) {
        if (element.eContainer() instanceof BlockArchitecture) {
            return !element.eContainingFeature().isMany();
        }
        return false;
    }
}

