/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.quickfix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.diffmerge.patterns.capella.quickfix.AbstractPatternCapellaMarkerResolution;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IPatternConformityStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.SimpleStatus;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.support.gen.commonpatternsupport.CommonPatternInstance;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;

public class PatternCapellaMarkerResolution
extends AbstractPatternCapellaMarkerResolution {
    Map<IMarker, Collection<IPatternInstance>> marker2InvalidPatternInstances = new HashMap<IMarker, Collection<IPatternInstance>>();

    protected boolean shouldKeepElements() {
        return false;
    }

    @Override
    public void run(IMarker marker) {
        final boolean[] mustDeleteMarker = new boolean[1];
        if (!this.marker2InvalidPatternInstances.get(marker).isEmpty()) {
            for (final IPatternInstance instance : this.marker2InvalidPatternInstances.get(marker)) {
                AbstractReadWriteCommand abstrctCommand = new AbstractReadWriteCommand(){

                    public void run() {
                        EObject patternStorage = null;
                        if (instance instanceof CommonPatternInstance) {
                            patternStorage = ((CommonPatternInstance)instance).eContainer();
                        }
                        if (PatternCapellaMarkerResolution.this.shouldKeepElements()) {
                            instance.delete(true);
                        } else {
                            instance.delete(false);
                        }
                        if (patternStorage != null) {
                            PatternCapellaMarkerResolution.this.deletePatternStorage(patternStorage);
                        }
                        mustDeleteMarker[0] = true;
                    }
                };
                if (!(instance instanceof EObject)) continue;
                TransactionHelper.getExecutionManager((EObject)((EObject)instance)).execute((ICommand)abstrctCommand);
            }
        }
        if (mustDeleteMarker[0]) {
            try {
                marker.delete();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    protected boolean enabled(Collection<IMarker> markers) {
        for (IMarker marker : markers) {
            ArrayList<IPatternInstance> invalidPatternInstances = new ArrayList<IPatternInstance>();
            List modelElements = this.getModelElements(marker);
            if (modelElements.isEmpty()) {
                return false;
            }
            EObject modelElement = (EObject)modelElements.get(0);
            IPatternSupport support = CorePatternsPlugin.getDefault().getPatternSupportFor(modelElement);
            if (support != null) {
                List instances = support.getRelatedInstances(modelElement);
                for (IPatternInstance instance : instances) {
                    IPatternConformityStatus status;
                    List roleElements = LocationsUtil.getRoleElements((IPatternApplication)instance);
                    if (!roleElements.contains(modelElement)) continue;
                    List featuresToIgnore = Collections.emptyList();
                    ISemanticRuleProvider provider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor((Object)modelElement);
                    if (provider != null) {
                        featuresToIgnore = provider.getDefaultOptionalMergeFeatures();
                    }
                    if ((status = instance.checkConformance(featuresToIgnore)) != SimpleStatus.NO_PATTERN_FAILURE) continue;
                    invalidPatternInstances.add(instance);
                }
            }
            this.marker2InvalidPatternInstances.put(marker, invalidPatternInstances);
            if (!invalidPatternInstances.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected boolean quickFixAllSimilarEnabled(Collection<IMarker> markers) {
        return false;
    }
}

