/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.progress.model;

import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractBusinessThread
extends Observable
implements Runnable,
Observer {
    private boolean _isRunning = false;

    @Override
    public void run() {
        this._isRunning = true;
        int min = this.getMinimum();
        int max = this.getMaximum();
        int step = this.getStep();
        HashMap<String, Object> info = new HashMap<String, Object>();
        int i = min;
        while (i < max) {
            info.put("Progress", i);
            info.put("Min", min);
            info.put("Max", max);
            info.put("Step", step);
            info.put("Finished", Boolean.FALSE);
            this.doRun(info);
            this.setChanged();
            this.notifyObservers(info);
            while (!this._isRunning) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            i += step;
        }
        info.put("Finished", Boolean.TRUE);
        this.setChanged();
        this.notifyObservers(info);
    }

    public abstract void doRun(HashMap<String, Object> var1);

    public abstract int getMinimum();

    public abstract int getMaximum();

    public abstract int getStep();

    public synchronized void setRunning(boolean running) {
        this._isRunning = running;
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setRunning(!this.isRunning());
    }
}

