/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.operations.ShowAnnotationOperation;

public class ShowAnnotationAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ICVSResource resource = this.getSingleSelectedCVSResource();
        if (resource == null) {
            return;
        }
        this.execute(resource);
    }

    public void execute(ICVSResource cvsResource) throws InvocationTargetException, InterruptedException {
        String revision = this.getRevision(cvsResource);
        if (revision == null) {
            return;
        }
        boolean binary = this.isBinary(cvsResource);
        if (binary) {
            IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
            String option = store.getString("pref_annotate_promptforbinary");
            if (option.equals("prompt")) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)CVSUIMessages.ShowAnnotationAction_2, (String)NLS.bind((String)CVSUIMessages.ShowAnnotationAction_3, (Object[])new String[]{cvsResource.getName()}), (String)CVSUIMessages.ShowAnnotationOperation_4, (boolean)false, (IPreferenceStore)store, (String)"pref_annotate_promptforbinary");
                int result = dialog.getReturnCode();
                switch (result) {
                    case 3: {
                        return;
                    }
                }
            } else if (option.equals("never")) {
                return;
            }
        }
        new ShowAnnotationOperation(this.getTargetPart(), cvsResource, revision, binary).run();
    }

    private boolean isBinary(ICVSResource cvsResource) {
        byte[] syncBytes;
        block4: {
            if (cvsResource.isFolder()) {
                return false;
            }
            try {
                syncBytes = ((ICVSFile)cvsResource).getSyncBytes();
                if (syncBytes != null) break block4;
                return false;
            }
            catch (CVSException cVSException) {
                return false;
            }
        }
        return ResourceSyncInfo.isBinary((byte[])syncBytes);
    }

    @Override
    public boolean isEnabled() {
        ICVSResource resource = this.getSingleSelectedCVSResource();
        try {
            return resource != null && !resource.isFolder() && resource.isManaged();
        }
        catch (CVSException e) {
            return this.isEnabledForException((TeamException)((Object)e));
        }
    }

    private ICVSResource getSingleSelectedCVSResource() {
        ICVSResource[] cvsResources = this.getSelectedCVSResources();
        if (cvsResources.length == 1) {
            return cvsResources[0];
        }
        Object[] logEntries = this.getAdaptedSelection(LogEntry.class);
        if (logEntries.length == 1) {
            LogEntry aLogEntry = (LogEntry)logEntries[0];
            ICVSRemoteFile cvsRemoteFile = aLogEntry.getRemoteFile();
            return cvsRemoteFile;
        }
        Object[] fileRevisions = this.getAdaptedSelection(CVSFileRevision.class);
        if (fileRevisions.length == 1) {
            ICVSRemoteFile cvsRemoteFile = ((CVSFileRevision)fileRevisions[0]).getCVSRemoteFile();
            return cvsRemoteFile;
        }
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 1) {
            return this.getCVSResourceFor(resources[0]);
        }
        return null;
    }

    private String getRevision(ICVSResource cvsResource) throws InvocationTargetException {
        ResourceSyncInfo info;
        try {
            info = cvsResource.getSyncInfo();
            if (info == null) {
                throw new CVSException(NLS.bind((String)CVSUIMessages.ShowAnnotationAction_noSyncInfo, (Object[])new String[]{cvsResource.getName()}));
            }
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
        return info.getRevision();
    }

    @Override
    public String getId() {
        return "org.eclipse.team.cvs.ui.showAnnotation";
    }
}

