/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.function;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class Functional_Exchange_Transitioned
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        boolean targetTest = false;
        boolean sourceTest = false;
        EObject eObj = ctx.getTarget();
        if (SystemEngineeringExt.findArchitecture((EObject)eObj) instanceof OperationalAnalysis) {
            return ctx.createSuccessStatus();
        }
        if (eObj instanceof FunctionalExchange) {
            FunctionalExchange functionalExchange = (FunctionalExchange)eObj;
            ActivityNode source = functionalExchange.getSource();
            ActivityNode target = functionalExchange.getTarget();
            EObject objectSource = null;
            EObject objectTarget = null;
            if (source != null && target != null) {
                if (source instanceof FunctionPort) {
                    objectSource = ((FunctionPort)source).eContainer();
                } else if (source instanceof AbstractFunction) {
                    objectSource = ((AbstractFunction)source).eContainer();
                }
                if (target instanceof FunctionPort) {
                    objectTarget = ((FunctionPort)target).eContainer();
                } else if (target instanceof AbstractFunction) {
                    objectTarget = ((AbstractFunction)target).eContainer();
                }
            }
            if (objectSource instanceof AbstractFunction && objectTarget instanceof AbstractFunction) {
                EList outgoingSource = ((AbstractFunction)objectSource).getOutgoingTraces();
                EList outgoingTarget = ((AbstractFunction)objectTarget).getOutgoingTraces();
                if (outgoingSource.isEmpty() || outgoingTarget.isEmpty()) {
                    return ctx.createSuccessStatus();
                }
                EList outgoingExchanges = functionalExchange.getOutgoingTraces();
                for (AbstractTrace abstractTrace : outgoingExchanges) {
                    ActivityNode targetNode;
                    ActivityNode sourceNode;
                    TraceableElement sourceElement = abstractTrace.getTargetElement();
                    if (!(sourceElement instanceof FunctionalExchange)) continue;
                    ActivityNode sourceObject = sourceNode = ((FunctionalExchange)sourceElement).getSource();
                    if (sourceNode instanceof FunctionPort) {
                        sourceObject = sourceNode.eContainer();
                    }
                    ActivityNode targetObject = targetNode = ((FunctionalExchange)sourceElement).getTarget();
                    if (targetNode instanceof FunctionPort) {
                        targetObject = targetNode.eContainer();
                    }
                    for (AbstractTrace trace : outgoingTarget) {
                        if (!trace.getTargetElement().equals(targetObject)) continue;
                        targetTest = true;
                    }
                    for (AbstractTrace abstractTrace2 : outgoingSource) {
                        if (!abstractTrace2.getTargetElement().equals(sourceObject)) continue;
                        sourceTest = true;
                    }
                }
            }
            if (sourceTest && targetTest) {
                return ctx.createSuccessStatus();
            }
            ActivityNode eSource = functionalExchange.getSource();
            ActivityNode eTarget = functionalExchange.getTarget();
            return ctx.createFailureStatus(new Object[]{functionalExchange.getName(), eSource == null ? null : eSource.eContainer(), eTarget == null ? null : eTarget.eContainer()});
        }
        return ctx.createFailureStatus(new Object[0]);
    }
}

