/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.ide.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.validation.ui.ide.PluginActivator;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class CommandMarkerResolution
extends AbstractCapellaMarkerResolution {
    private ICommand command;

    public CommandMarkerResolution(ICommand command) {
        this.command = command;
    }

    public void run(IMarker marker) {
        this.getExecutionManager(marker).execute(this.command);
        this.deleteMarker(marker);
    }

    @Override
    public String getLabel() {
        return this.command.getName();
    }

    protected ExecutionManager getExecutionManager(IMarker marker) {
        return TransactionHelper.getExecutionManager(this.getModelElements(marker));
    }

    protected void deleteMarker(IMarker marker) {
        if (marker.exists()) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                PluginActivator.getDefault().log(4, e.getLocalizedMessage(), e);
            }
        }
    }
}

