/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.mapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.helpers.interaction.services.MessageEndExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.CapabilityRealizationExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.refinement.scenarios.core.RefinementServices;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.MapperException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IMapper;

public class StandardMapper
implements IMapper {
    public Object getName() {
        return "Standard Mapper";
    }

    public List<AbstractInstance> candidateComponents(AbstractInstance abstractInstance, boolean isIntraLayer, Component decomposedComponent, NamedElement target, Scenario srcScenario, AbstractEnd srcAbstractEnd) throws MapperException {
        List<AbstractInstance> partSet;
        block9: {
            AbstractType partType;
            block13: {
                block11: {
                    block12: {
                        block10: {
                            block7: {
                                block8: {
                                    partSet = new ArrayList<AbstractInstance>();
                                    partType = abstractInstance.getAbstractType();
                                    if (!(partType instanceof AbstractActor)) break block7;
                                    if (!isIntraLayer) break block8;
                                    partSet.add(abstractInstance);
                                    break block9;
                                }
                                AbstractActor abstractActor = this.getActorProjection((AbstractActor)partType, isIntraLayer);
                                if (abstractActor == null) break block9;
                                Part projectedPart = this.getPartProjection((Part)abstractInstance);
                                if (projectedPart != null && abstractActor.equals(projectedPart.getAbstractType())) {
                                    partSet.add((AbstractInstance)projectedPart);
                                } else {
                                    partSet.addAll(RefinementServices.getReferencerParts((Component)abstractActor));
                                }
                                break block9;
                            }
                            if (!(partType instanceof System)) break block10;
                            LogicalComponent rootLc = SystemEngineeringExt.getRootLogicalComponent((LogicalArchitecture)((LogicalArchitecture)target));
                            if (rootLc == null) break block9;
                            for (Part part : ComponentExt.getDecompositionPartInvolved((Component)rootLc)) {
                                partSet.add((AbstractInstance)part);
                            }
                            break block9;
                        }
                        if (!(partType instanceof LogicalComponent)) break block11;
                        if (!isIntraLayer) break block12;
                        partSet = this.getCandidateComponentFromSourceScenario((Part)abstractInstance, decomposedComponent);
                        if (partSet.size() != 0) break block9;
                        LogicalComponent containerLC = LogicalComponentExt.getLogicalComponentContainerFromScenario((Scenario)srcScenario);
                        for (Part currentBrother : ComponentExt.getDecompositionPartInvolved((Component)containerLC)) {
                            if (currentBrother.getAbstractType().equals(decomposedComponent)) continue;
                            partSet.add((AbstractInstance)currentBrother);
                        }
                        partSet.addAll(ComponentExt.getDecompositionPartInvolved((Component)((LogicalComponent)target)));
                        partSet.addAll(StandardMapper.getParentBrothersInvolved(containerLC, srcScenario));
                        break block9;
                    }
                    for (PhysicalComponent physicalComponent : LogicalComponentExt.getImplementors((LogicalComponent)((LogicalComponent)partType))) {
                        partSet.addAll(RefinementServices.getReferencerParts((Component)physicalComponent));
                    }
                    break block9;
                }
                if (!(partType instanceof PhysicalComponent)) break block9;
                if (!isIntraLayer) break block13;
                partSet = this.getCandidateComponentFromSourceScenario((Part)abstractInstance, decomposedComponent);
                if (partSet.size() != 0) break block9;
                PhysicalComponent containerPC = PhysicalComponentExt.getPhysicalComponentContainerFromScenario((Scenario)srcScenario);
                for (Part currentBrother : ComponentExt.getDecompositionPartInvolved((Component)containerPC)) {
                    if (currentBrother.getAbstractType().equals(decomposedComponent)) continue;
                    partSet.add((AbstractInstance)currentBrother);
                }
                partSet.addAll(ComponentExt.getDecompositionPartInvolved((Component)((PhysicalComponent)target)));
                partSet.addAll(StandardMapper.getParentBrothersInvolved(containerPC, srcScenario));
                break block9;
            }
            for (ConfigurationItem ci : PhysicalComponentExt.getImplementors((PhysicalComponent)((PhysicalComponent)partType))) {
                partSet.addAll(RefinementServices.getReferencerParts((Component)ci));
            }
        }
        return partSet;
    }

    private List<AbstractInstance> getCandidateComponentFromSourceScenario(Part part, Component decomposedComponent) {
        ArrayList<AbstractInstance> componentSet = new ArrayList<AbstractInstance>();
        Component component = (Component)part.getAbstractType();
        if (component == decomposedComponent) {
            componentSet.addAll(ComponentExt.getDecompositionPartInvolved((Component)component));
        } else {
            componentSet.add((AbstractInstance)part);
        }
        return componentSet;
    }

    private AbstractActor getActorProjection(AbstractActor abstractActor, boolean isIntraLayer) {
        AbstractActor actorProjected = null;
        if (isIntraLayer && abstractActor instanceof LogicalActor) {
            actorProjected = abstractActor;
        } else if (!isIntraLayer && abstractActor instanceof PhysicalActor) {
            actorProjected = abstractActor;
        } else if (abstractActor instanceof Actor) {
            actorProjected = (LogicalActor)this.getReconciliation((TraceableElement)abstractActor, LaPackage.Literals.LOGICAL_ACTOR, LaPackage.Literals.SYSTEM_ACTOR_REALIZATION);
        } else if (abstractActor instanceof LogicalActor) {
            actorProjected = (PhysicalActor)this.getReconciliation((TraceableElement)abstractActor, PaPackage.Literals.PHYSICAL_ACTOR, PaPackage.Literals.LOGICAL_ACTOR_REALIZATION);
        }
        return actorProjected;
    }

    private Part getPartProjection(Part part) {
        return (Part)this.getReconciliation((TraceableElement)part, CsPackage.Literals.PART, CapellacommonPackage.Literals.TRANSFO_LINK);
    }

    public List<AbstractInstance> componentMapping(MessageEndExt.COMPONENT_TYPE componentType, AbstractEventOperation invokedOperation, List<AbstractInstance> candidateAbstractInstances, AbstractEnd abstractEnd) throws MapperException {
        ArrayList<AbstractInstance> componentSet = new ArrayList<AbstractInstance>();
        for (AbstractInstance abstractInstance : candidateAbstractInstances) {
            AbstractType type = abstractInstance.getAbstractType();
            if (!(type instanceof Component)) continue;
            Component cpnt = (Component)type;
            if (componentType == MessageEndExt.COMPONENT_TYPE.SENDER) {
                if (!this.isUsingOperation((NamedElement)cpnt, invokedOperation)) continue;
                componentSet.add(abstractInstance);
                continue;
            }
            if (componentType != MessageEndExt.COMPONENT_TYPE.RECEIVER || !this.isImplementingOperation((NamedElement)cpnt, invokedOperation)) continue;
            componentSet.add(abstractInstance);
        }
        return componentSet;
    }

    private boolean isImplementingOperation(NamedElement implementorComponent, AbstractEventOperation implementedOperation) {
        List itfLst = null;
        if (implementorComponent instanceof Component) {
            itfLst = ComponentExt.getAllImplementedAndProvidedInterfaces((Component)((Component)implementorComponent));
        }
        if (itfLst != null) {
            for (Interface cls : itfLst) {
                EList lstOp = cls.getOwnedExchangeItemAllocations();
                if (lstOp.contains(implementedOperation)) {
                    return true;
                }
                for (ExchangeItemAllocation operation : lstOp) {
                    List lstOpDelegated = RefinementServices.getDelegatedAndRefinedOperations((AbstractEventOperation)operation, (boolean)true);
                    if (!lstOpDelegated.contains(implementedOperation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isUsingOperation(NamedElement userComponent, AbstractEventOperation usedOperation) {
        List itfLst = null;
        if (userComponent instanceof AbstractActor) {
            itfLst = ComponentExt.getAllUsedAndRequiredInterfaces((Component)((AbstractActor)userComponent));
        } else if (userComponent instanceof Component) {
            itfLst = ComponentExt.getAllUsedAndRequiredInterfaces((Component)((Component)userComponent));
        }
        if (itfLst != null) {
            for (Interface itf : itfLst) {
                EList lstOp = itf.getOwnedExchangeItemAllocations();
                if (lstOp.contains(usedOperation)) {
                    return true;
                }
                for (ExchangeItemAllocation operation : lstOp) {
                    List lstOpDelegated = RefinementServices.getDelegatedAndRefinedOperations((AbstractEventOperation)operation, (boolean)true);
                    if (!lstOpDelegated.contains(usedOperation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public TraceableElement getReconciliation(TraceableElement src, EClass tgtMC, EClass linkMC) {
        for (AbstractTrace abstractTrace : src.getIncomingTraces()) {
            TraceableElement traceableElt;
            if (abstractTrace.eClass() != linkMC || (traceableElt = abstractTrace.getSourceElement()) == null || traceableElt.eClass() != tgtMC) continue;
            return traceableElt;
        }
        return null;
    }

    private static List<Part> getParentBrothersInvolved(LogicalComponent component, Scenario srcScenario) {
        List involvedLcByUpperCapa = CapabilityRealizationExt.retrieveLcInvolvedByUpperCapabilityRealization((AbstractCapability)ScenarioExt.getRelatedCapability((Scenario)srcScenario));
        List<Part> listParentBrother = StandardMapper.getBrothersRecursively((Component)component, involvedLcByUpperCapa);
        return listParentBrother;
    }

    private static List<Part> getParentBrothersInvolved(PhysicalComponent component, Scenario srcScenario) {
        List involvedPcByUpperCapa = CapabilityRealizationExt.retrievePcInvolvedByUpperCapabilityRealization((AbstractCapability)ScenarioExt.getRelatedCapability((Scenario)srcScenario));
        List<Part> listParentBrother = StandardMapper.getBrothersRecursively((Component)component, involvedPcByUpperCapa);
        return listParentBrother;
    }

    private static List<Part> getBrothersRecursively(Component component, List<? extends Component> involvedCpntByUpperCapa) {
        ArrayList<Part> listParentBrothers = new ArrayList<Part>();
        for (Component currentFatherCpnt : ComponentExt.getDirectParents((Component)component)) {
            if (!involvedCpntByUpperCapa.contains(currentFatherCpnt) && !ComponentExt.isComponentRoot((EObject)currentFatherCpnt)) continue;
            for (Part currentBrotherCpnt : ComponentExt.getDecompositionPartInvolved((Component)currentFatherCpnt)) {
                if (currentBrotherCpnt.getAbstractType() == component || !involvedCpntByUpperCapa.contains(currentBrotherCpnt.getAbstractType()) || listParentBrothers.contains(currentBrotherCpnt)) continue;
                listParentBrothers.add(currentBrotherCpnt);
            }
            for (Part upperParentBrother : StandardMapper.getBrothersRecursively(currentFatherCpnt, involvedCpntByUpperCapa)) {
                if (listParentBrothers.contains(upperParentBrother)) continue;
                listParentBrothers.add(upperParentBrother);
            }
        }
        return listParentBrothers;
    }
}

