/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.queries.queryContext;

import java.util.Hashtable;
import java.util.List;
import org.polarsys.capella.common.queries.internal.IPrivateQueryContext;

public abstract class AbstractQueryContext
implements IPrivateQueryContext {
    private int callingLevel = 0;
    private Hashtable<Integer, Hashtable<Object, List<Object>>> queryIdentifierToCacheTable = new Hashtable();

    @Override
    public int getExecutionLevel() {
        return this.callingLevel;
    }

    @Override
    public List<Object> getResultFromCache(Integer queryId, Object semanticsObject) {
        Hashtable<Object, List<Object>> cacheTable = this.queryIdentifierToCacheTable.get(queryId);
        if (cacheTable == null) {
            return null;
        }
        return cacheTable.get(semanticsObject);
    }

    @Override
    public void addInCache(Integer queryId, Object semanticsObject, List<Object> res) {
        Hashtable<Object, List<Object>> cacheTable = this.queryIdentifierToCacheTable.get(queryId);
        if (cacheTable == null) {
            cacheTable = new Hashtable();
            this.queryIdentifierToCacheTable.put(queryId, cacheTable);
        }
        cacheTable.put(semanticsObject, res);
    }

    @Override
    public void resetCache() {
        this.queryIdentifierToCacheTable = new Hashtable();
    }

    @Override
    public void incCallLevel() {
        ++this.callingLevel;
    }

    @Override
    public void decCallLevel() {
        --this.callingLevel;
    }
}

