/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers.transfer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.capella.common.ui.toolkit.UI;
import org.polarsys.capella.common.ui.toolkit.viewers.transfer.Messages;
import org.polarsys.capella.common.ui.toolkit.widgets.handler.SelectionChangedHandler;

public abstract class AbstractTransferViewer2
extends Viewer {
    public static final int STATUS_TEXT_FIELD = 2;
    public static final int ADD_ALL_BUTTON = 4;
    public static final int ADD_SELECTED_BUTTON = 8;
    public static final int REMOVE_SELECTED_BUTTON = 16;
    public static final int REMOVE_ALL_BUTTON = 32;
    public static final int SINGLE_SELECTION_VIEWER = 64;
    public static final int ALL_BUTTONS = 60;
    public static final int ALL_WIDGETS = 62;
    private int _style;
    private Composite _composite;
    private Text _statusBar;
    private Composite _buttonsPanel;
    private Button _addAllBtn;
    Button _addSelectedBtn;
    Button _removeSelectedBtn;
    private Button _removeAllBtn;
    private StructuredViewer _leftViewer;
    private int _leftViewerStyleBits;
    protected int _leftViewerExpandLevel;
    private StructuredViewer _rightViewer;
    private int _rightViewerStyleBits;
    protected int _rightViewerExpandLevel;
    private SelectionListener _buttonClickedListener;
    private ISelectionChangedListener _viewerSelectionChangedListener;
    private List<SelectionChangedHandler> _selectionChangedHandlersForBothViewers;
    private List<SelectionChangedHandler> _selectionChangedHandlersForLeftViewer;
    private List<SelectionChangedHandler> _selectionChangedHandlersForRightViewer;

    protected AbstractTransferViewer2(Composite parent, int style, int leftViewerStyleBits, int rightViewerStyleBits) {
        this(parent, style, leftViewerStyleBits, rightViewerStyleBits, -1, -1);
    }

    protected AbstractTransferViewer2(Composite parent, int style, int leftViewerStyleBits, int rightViewerStyleBits, int leftViewerExpandLevel, int rightViewerExpandLevel) {
        this._style = style == 0 ? 62 : style;
        this._selectionChangedHandlersForBothViewers = new ArrayList<SelectionChangedHandler>(0);
        this._selectionChangedHandlersForLeftViewer = new ArrayList<SelectionChangedHandler>(0);
        this._selectionChangedHandlersForRightViewer = new ArrayList<SelectionChangedHandler>(0);
        this._leftViewerStyleBits = leftViewerStyleBits;
        this._rightViewerStyleBits = rightViewerStyleBits;
        this._leftViewerExpandLevel = leftViewerExpandLevel;
        this._rightViewerExpandLevel = rightViewerExpandLevel;
        this.createViewer(parent);
    }

    protected Button createButton(Composite parent, String text, String tooltip) {
        Button button = new Button(parent, 0x1000000);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gdData);
        button.setText(text);
        button.setToolTipText(tooltip);
        button.addSelectionListener(this._buttonClickedListener);
        return button;
    }

    protected void createButtonArea(Composite parent) {
        this._buttonsPanel = new Composite(parent, 0);
        GridData gdData = new GridData();
        gdData.widthHint = UI.convertHorizontalDLUsToPixels((Control)this._buttonsPanel, 61);
        gdData.verticalAlignment = 2;
        gdData.grabExcessVerticalSpace = true;
        this._buttonsPanel.setLayoutData((Object)gdData);
        GridLayout buttonsLayout = new GridLayout(1, true);
        this._buttonsPanel.setLayout((Layout)buttonsLayout);
        if ((4 & this._style) != 0) {
            this._addAllBtn = this.createButton(this._buttonsPanel, ">>", Messages.AbstractTransferViewer2_AddAllElements_Tooltip);
        }
        if ((8 & this._style) != 0) {
            this._addSelectedBtn = this.createButton(this._buttonsPanel, ">", Messages.AbstractTransferViewer2_AddSelectedElements_Tooltip);
        }
        if ((0x10 & this._style) != 0) {
            this._removeSelectedBtn = this.createButton(this._buttonsPanel, "<", Messages.AbstractTransferViewer2_RemoveSelectedElements_Tooltip);
        }
        if ((0x20 & this._style) != 0) {
            this._removeAllBtn = this.createButton(this._buttonsPanel, "<<", Messages.AbstractTransferViewer2_RemoveAllElements_Tooltip);
        }
    }

    private void createInternalComposite(Composite parent) {
        this._composite = new Composite(parent, 0);
        this._composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 4, true, true);
        this._composite.setLayoutData((Object)gridData);
    }

    private void createLeftViewer(Composite parent) {
        if (this._leftViewer == null) {
            this._leftViewer = this.doLeftViewer(parent);
        }
        this.layoutViewer(this._leftViewer, Messages.AbstractTransferViewer2_LeftViewer_Title);
    }

    private void createRightViewer(Composite parent) {
        if (this._rightViewer == null) {
            this._rightViewer = this.doRightViewer(parent);
        }
        this.layoutViewer(this._rightViewer, Messages.AbstractTransferViewer2_RightViewer_Title);
    }

    private void createStatusTextField(Composite parent) {
        if ((2 & this._style) != 0) {
            this._statusBar = new Text(parent, 2056);
            this._statusBar.setEditable(false);
            GridData gdData = new GridData();
            gdData.horizontalAlignment = 4;
            gdData.grabExcessHorizontalSpace = true;
            gdData.horizontalSpan = 3;
            this._statusBar.setLayoutData((Object)gdData);
        }
    }

    private void createViewer(Composite parent) {
        this.createInternalComposite(parent);
        this.initializeListeners();
        this.createLeftViewer(this._composite);
        this.createButtonArea(this._composite);
        this.createRightViewer(this._composite);
        this.createStatusTextField(this._composite);
    }

    public void dispose() {
        if (this._composite != null && !this._composite.isDisposed()) {
            this._composite.dispose();
            this._composite = null;
        }
        this._buttonClickedListener = null;
        this._addAllBtn = null;
        this._addSelectedBtn = null;
        this._removeSelectedBtn = null;
        this._removeAllBtn = null;
        if (this._leftViewer != null) {
            this._leftViewer.removeSelectionChangedListener(this._viewerSelectionChangedListener);
            this._leftViewer = null;
        }
        if (this._rightViewer != null) {
            this._rightViewer.removeSelectionChangedListener(this._viewerSelectionChangedListener);
            this._rightViewer = null;
        }
        this._viewerSelectionChangedListener = null;
    }

    protected boolean doHandleAddAllButton() {
        boolean changed = false;
        Object input = this._leftViewer.getInput();
        if (input != null) {
            changed = true;
            this._leftViewer.setInput(null);
            this._rightViewer.setInput(input);
        }
        return changed;
    }

    protected boolean doHandleAddSelectedButton() {
        boolean changed = false;
        ISelection leftSelection = this._leftViewer.getSelection();
        if (!leftSelection.isEmpty()) {
            changed = true;
            IStructuredSelection structuredSelection = (IStructuredSelection)leftSelection;
            Object[] elements = structuredSelection.toArray();
            this._leftViewer.getContentProvider().inputChanged((Viewer)this._leftViewer, (Object)elements, null);
            this._rightViewer.getContentProvider().inputChanged((Viewer)this._rightViewer, null, (Object)elements);
        }
        return changed;
    }

    protected boolean doHandleRemoveAllButton() {
        boolean changed = false;
        Object input = this._rightViewer.getInput();
        if (input != null) {
            changed = true;
            this._rightViewer.setInput(null);
            this._leftViewer.setInput(input);
        }
        return changed;
    }

    protected boolean doHandleRemoveSelectedButton() {
        boolean changed = false;
        ISelection rightSelection = this._rightViewer.getSelection();
        if (!rightSelection.isEmpty()) {
            changed = true;
            IStructuredSelection structuredSelection = (IStructuredSelection)rightSelection;
            Object[] elements = structuredSelection.toArray();
            this._leftViewer.getContentProvider().inputChanged((Viewer)this._leftViewer, null, (Object)elements);
            this._rightViewer.getContentProvider().inputChanged((Viewer)this._rightViewer, (Object)elements, null);
        }
        return changed;
    }

    protected abstract StructuredViewer doLeftViewer(Composite var1);

    protected abstract StructuredViewer doRightViewer(Composite var1);

    protected Composite getButtonsContainer() {
        return this._buttonsPanel;
    }

    public Control getControl() {
        return this._composite;
    }

    public Object getInput() {
        return null;
    }

    public IContentProvider getLeftContentProvider() {
        IContentProvider provider = null;
        if (this._leftViewer != null) {
            provider = this._leftViewer.getContentProvider();
        }
        return provider;
    }

    public Object getLeftInput() {
        Object object = null;
        if (this._leftViewer != null) {
            object = this._leftViewer.getInput();
        }
        return object;
    }

    public IBaseLabelProvider getLeftLabelProvider() {
        IBaseLabelProvider provider = null;
        if (this._leftViewer != null) {
            provider = this._leftViewer.getLabelProvider();
        }
        return provider;
    }

    public StructuredViewer getLeftViewer() {
        return this._leftViewer;
    }

    protected int getLeftViewerStyleBits() {
        return this._leftViewerStyleBits;
    }

    public IContentProvider getRightContentProvider() {
        IContentProvider provider = null;
        if (this._rightViewer != null) {
            provider = this._rightViewer.getContentProvider();
        }
        return provider;
    }

    public Object getRightInput() {
        Object object = null;
        if (this._rightViewer != null) {
            object = this._rightViewer.getInput();
        }
        return object;
    }

    public IBaseLabelProvider getRightLabelProvider() {
        IBaseLabelProvider provider = null;
        if (this._rightViewer != null) {
            provider = this._rightViewer.getLabelProvider();
        }
        return provider;
    }

    public StructuredViewer getRightViewer() {
        return this._rightViewer;
    }

    protected int getRightViewerStyleBits() {
        return this._rightViewerStyleBits;
    }

    public ISelection getSelection() {
        return null;
    }

    protected List<SelectionChangedHandler> getSelectionChangedHandlersForBothViewers() {
        return this._selectionChangedHandlersForBothViewers;
    }

    protected List<SelectionChangedHandler> getSelectionChangedHandlersForLeftViewer() {
        return this._selectionChangedHandlersForLeftViewer;
    }

    protected List<SelectionChangedHandler> getSelectionChangedHandlersForRightViewer() {
        return this._selectionChangedHandlersForRightViewer;
    }

    protected void handleButtonClicked(Widget button) {
        if (button == this._addAllBtn) {
            this.doHandleAddAllButton();
        } else if (button == this._addSelectedBtn) {
            this.doHandleAddSelectedButton();
        } else if (button == this._removeSelectedBtn) {
            this.doHandleRemoveSelectedButton();
        } else if (button == this._removeAllBtn) {
            this.doHandleRemoveAllButton();
        }
    }

    protected String handleStatusLineUpdate(Object selectedElement, SelectionChangedEvent event) {
        String result = "";
        ContentViewer source = (ContentViewer)event.getSource();
        ILabelProvider labelProvider = (ILabelProvider)source.getLabelProvider();
        result = labelProvider.getText(selectedElement);
        return result;
    }

    protected void handleViewersSelectionMode(SelectionChangedEvent event) {
        if ((this._style & 0x40) != 0 && !event.getSelection().isEmpty()) {
            ISelectionProvider selectionProvider = event.getSelectionProvider();
            if (selectionProvider == this._leftViewer) {
                this._addSelectedBtn.setEnabled(true);
                this._removeSelectedBtn.setEnabled(false);
                this.clearSelection(this._rightViewer);
            } else if (selectionProvider == this._rightViewer) {
                this._addSelectedBtn.setEnabled(false);
                this._removeSelectedBtn.setEnabled(true);
                this.clearSelection(this._leftViewer);
            }
        }
    }

    protected void clearSelection(StructuredViewer viewer) {
        if (!viewer.getSelection().isEmpty()) {
            viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void initializeListeners() {
        this._buttonClickedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget button = event.widget;
                AbstractTransferViewer2.this.handleButtonClicked(button);
            }
        };
        this._viewerSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTransferViewer2.this.handleViewersSelectionMode(event);
                ISelection selection = event.getSelection();
                AbstractTransferViewer2.this.updateButtons(selection, event.getSelectionProvider());
                if (!selection.isEmpty()) {
                    IStructuredSelection structSelection = (IStructuredSelection)selection;
                    Object lastSelected = structSelection.toList().get(structSelection.size() - 1);
                    AbstractTransferViewer2.this.updateStatusLine(AbstractTransferViewer2.this.handleStatusLineUpdate(lastSelected, event));
                }
            }
        };
        this._composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                Control leftControl = AbstractTransferViewer2.this._leftViewer.getControl();
                Point leftViewerSize = leftControl.computeSize(-1, -1);
                Control rightControl = AbstractTransferViewer2.this._rightViewer.getControl();
                Point rightViewerSize = rightControl.computeSize(-1, -1);
                int width = Math.max(leftViewerSize.x, rightViewerSize.x);
                GridData gd = (GridData)leftControl.getLayoutData();
                gd.widthHint = width;
                gd = (GridData)rightControl.getLayoutData();
                gd.widthHint = width;
            }
        });
    }

    private void layoutViewer(StructuredViewer viewer, String tooltip) {
        if (viewer == null) {
            return;
        }
        viewer.setUseHashlookup(true);
        Control control = viewer.getControl();
        control.setToolTipText(tooltip);
        viewer.addSelectionChangedListener(this._viewerSelectionChangedListener);
        GridData gdData = new GridData(4, 4, true, true);
        control.setLayoutData((Object)gdData);
    }

    private void notifySelectionChangedHandler(ISelection selection, List<SelectionChangedHandler> handlers) {
        if (handlers != null) {
            for (SelectionChangedHandler handler : handlers) {
                handler.handleSelection(selection);
            }
        }
    }

    public void refresh() {
        this._leftViewer.refresh();
        this._rightViewer.refresh();
    }

    public void setInput(Object input) {
    }

    public void setLeftContentProvider(IContentProvider provider) {
        this._leftViewer.setContentProvider(provider);
    }

    public void setLeftInput(Object input) {
        this._leftViewer.setInput(input);
    }

    public void setLeftLabelProvider(ILabelProvider provider) {
        this._leftViewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    public void setRightContentProvider(IContentProvider provider) {
        this._rightViewer.setContentProvider(provider);
    }

    public void setRightInput(Object input) {
        this._rightViewer.setInput(input);
    }

    public void setRightLabelProvider(ILabelProvider provider) {
        this._rightViewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setSelectionChangedHandler(SelectionChangedHandler handler, int buttonStyleConstant) {
        if (this._addAllBtn != null && (4 & buttonStyleConstant) != 0) {
            handler.addControl((Control)this._addAllBtn);
            this._selectionChangedHandlersForBothViewers.add(handler);
        }
        if (this._removeAllBtn != null && (0x20 & buttonStyleConstant) != 0) {
            handler.addControl((Control)this._removeAllBtn);
            this._selectionChangedHandlersForBothViewers.add(handler);
        }
        if (this._addSelectedBtn != null && (8 & buttonStyleConstant) != 0) {
            handler.addControl((Control)this._addSelectedBtn);
            this._selectionChangedHandlersForLeftViewer.add(handler);
        }
        if (this._removeSelectedBtn != null && (0x10 & buttonStyleConstant) != 0) {
            handler.addControl((Control)this._removeSelectedBtn);
            this._selectionChangedHandlersForRightViewer.add(handler);
        }
    }

    protected void updateButtons(ISelection selection, ISelectionProvider selectionProvider) {
        List<SelectionChangedHandler> handlersForSelectionProvider = null;
        if (selectionProvider == this._leftViewer) {
            handlersForSelectionProvider = this._selectionChangedHandlersForLeftViewer;
        } else if (selectionProvider == this._rightViewer) {
            handlersForSelectionProvider = this._selectionChangedHandlersForRightViewer;
        }
        this.notifySelectionChangedHandler(selection, handlersForSelectionProvider);
        this.notifySelectionChangedHandler(selection, this._selectionChangedHandlersForBothViewers);
    }

    protected void updateStatusLine(String text) {
        if (this._statusBar != null) {
            this._statusBar.setText(text);
        }
    }
}

