/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.widgets.filter;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.PatternFilter;

public class TreePatternFilter
extends PatternFilter {
    private boolean _ignoreMatching;
    private Set<Object> _matchingParents;

    public TreePatternFilter() {
        this.setUseCache(true);
        this._matchingParents = new HashSet<Object>(0);
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result = false;
        Object parent = parentElement;
        if (parentElement instanceof TreePath) {
            parent = ((TreePath)parentElement).getLastSegment();
        }
        if (this._matchingParents.contains(parent)) {
            result = true;
            this._matchingParents.add(element);
        } else {
            result = this.isElementVisible(viewer, parent, element);
        }
        return result;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this._matchingParents.clear();
    }

    @Override
    protected boolean isLeafMatch(Viewer viewer, Object parentElement, Object element) {
        if (this._ignoreMatching) {
            return true;
        }
        return this.doIsLeafMatch(viewer, parentElement, element);
    }

    protected boolean doIsLeafMatch(Viewer viewer, Object parentElement, Object element) {
        boolean result = false;
        if (element instanceof EObject) {
            String textToMatch = this.getTextFromModelElement((EObject)element);
            if (textToMatch != null) {
                result = this.wordMatches(textToMatch);
            }
        } else {
            result = super.isLeafMatch(viewer, parentElement, element);
        }
        if (result) {
            result = !this.isLeafAlreadyFilteredOutByOtherFilters((StructuredViewer)viewer, parentElement, element);
        }
        return result;
    }

    protected String getTextFromModelElement(EObject element) {
        return EObjectLabelProviderHelper.getText((EObject)element);
    }

    @Override
    public boolean isElementVisible(Viewer viewer, Object parentElement, Object element) {
        boolean leafMatch = this.isLeafMatch(viewer, parentElement, element);
        boolean ignoreMatchingEnabled = false;
        if (leafMatch) {
            this._ignoreMatching = true;
            ignoreMatchingEnabled = true;
            this._matchingParents.add(element);
        }
        boolean parentMatch = this.isParentMatch(viewer, parentElement, element);
        if (ignoreMatchingEnabled) {
            this._ignoreMatching = false;
        }
        return leafMatch || parentMatch;
    }
}

