/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.datavalue.properties.sections;

import com.google.common.base.Objects;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.observable.DelayedObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.core.data.core.properties.sections.NamedElementSection;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditor;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;

public class OpaqueExpressionSection
extends NamedElementSection {
    private OpaqueExpression opaqueExpression;
    private Composite bodyEditorComposite;
    private TableViewer languagesViewer;
    private IObservableList elements = new WritableList(new ArrayList(), OpaqueExpressionElement.class);
    private final PropertyChangeListener bodyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            OpaqueExpressionSection.this.syncToModel();
        }
    };
    private Group opaqueExpressionGroup;
    private Button add;
    private Button remove;

    public boolean select(Object toTest) {
        return true;
    }

    private OpaqueExpression getOpaqueExpression() {
        return this.opaqueExpression;
    }

    private void setOpaqueExpression(OpaqueExpression expression) {
        this.opaqueExpression = expression;
    }

    private IObservableList getElements() {
        return this.elements;
    }

    public void loadData(EObject element) {
        super.loadData(element);
        if (this.getOpaqueExpression() != element) {
            this.setOpaqueExpression((OpaqueExpression)element);
            this.getElements().clear();
            int i = 0;
            while (i < Math.min(this.getOpaqueExpression().getLanguages().size(), this.getOpaqueExpression().getBodies().size())) {
                this.getElements().add((Object)new OpaqueExpressionElement(this.getOpaqueExpression(), (String)this.getOpaqueExpression().getLanguages().get(i), (String)this.getOpaqueExpression().getBodies().get(i)));
                ++i;
            }
            for (Object elt : this.getElements()) {
                ((OpaqueExpressionElement)elt).addPropertyChangeListener("body", this.bodyListener);
            }
            if (this.getElements().size() > 0) {
                this.languagesViewer.setSelection((ISelection)new StructuredSelection(this.getElements().get(0)));
            }
        } else {
            int i = 0;
            while (i < Math.min(this.getOpaqueExpression().getLanguages().size(), this.getOpaqueExpression().getBodies().size())) {
                String lang = (String)this.getOpaqueExpression().getLanguages().get(i);
                String body = (String)this.getOpaqueExpression().getBodies().get(i);
                int oldIndex = -1;
                int j = 0;
                while (j < this.getElements().size()) {
                    if (((OpaqueExpressionElement)this.getElements().get(j)).getLanguage().equals(lang)) {
                        oldIndex = j;
                        break;
                    }
                    ++j;
                }
                if (oldIndex == -1) {
                    this.getElements().add(i, (Object)new OpaqueExpressionElement(this.getOpaqueExpression(), lang, body));
                } else {
                    this.getElements().move(oldIndex, i);
                    ((OpaqueExpressionElement)this.getElements().get(i)).setBody(body);
                }
                while (this.elements.size() > this.opaqueExpression.getLanguages().size()) {
                    this.elements.remove(this.opaqueExpression.getLanguages().size());
                }
                ++i;
            }
        }
        this.updateRemoveButtonState(this.remove);
    }

    private void syncToModel() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.opaqueExpression);
        RecordingCommand c = new RecordingCommand(domain, "Edit OpaqueExpression"){
            final OpaqueExpression _affected;
            {
                this._affected = OpaqueExpressionSection.this.getOpaqueExpression();
            }

            public Collection<?> getAffectedObjects() {
                return Collections.singleton(this._affected);
            }

            protected void doExecute() {
                int i = 0;
                while (i < OpaqueExpressionSection.this.getElements().size()) {
                    OpaqueExpressionElement element = (OpaqueExpressionElement)OpaqueExpressionSection.this.getElements().get(i);
                    int oldIndex = -1;
                    int j = 0;
                    while (i < OpaqueExpressionSection.this.getOpaqueExpression().getLanguages().size()) {
                        if (((String)OpaqueExpressionSection.this.getOpaqueExpression().getLanguages().get(j)).equals(element.getLanguage())) {
                            oldIndex = j;
                            break;
                        }
                        ++j;
                    }
                    if (oldIndex == -1) {
                        OpaqueExpressionSection.this.getOpaqueExpression().getLanguages().add(i, (Object)element.getLanguage());
                        OpaqueExpressionSection.this.getOpaqueExpression().getBodies().add(i, (Object)element.getBody());
                    } else {
                        OpaqueExpressionSection.this.getOpaqueExpression().getLanguages().move(i, oldIndex);
                        OpaqueExpressionSection.this.getOpaqueExpression().getBodies().set(i, (Object)element.getBody());
                    }
                    ++i;
                }
                while (OpaqueExpressionSection.this.getElements().size() < OpaqueExpressionSection.this.getOpaqueExpression().getLanguages().size()) {
                    OpaqueExpressionSection.this.getOpaqueExpression().getLanguages().remove(OpaqueExpressionSection.this.getElements().size());
                }
                while (OpaqueExpressionSection.this.getElements().size() < OpaqueExpressionSection.this.getOpaqueExpression().getBodies().size()) {
                    OpaqueExpressionSection.this.getOpaqueExpression().getBodies().remove(OpaqueExpressionSection.this.getElements().size());
                }
            }
        };
        domain.getCommandStack().execute((Command)c);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout layout = new GridLayout(5, false);
        layout.marginBottom = 2;
        layout.marginLeft = 2;
        layout.marginRight = 2;
        layout.marginTop = 2;
        this.opaqueExpressionGroup = this.getWidgetFactory().createGroup(this.rootParentComposite, "");
        this.opaqueExpressionGroup.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.heightHint = 200;
        this.opaqueExpressionGroup.setLayoutData((Object)gd);
        Table table = this.getWidgetFactory().createTable((Composite)this.opaqueExpressionGroup, 4);
        this.languagesViewer = new TableViewer(table);
        this.languagesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OpaqueExpressionElement newElement = (OpaqueExpressionElement)((IStructuredSelection)event.getSelection()).getFirstElement();
                OpaqueExpressionSection.this.updateTextArea(newElement);
            }
        });
        GridData data = new GridData(4, 4, false, true);
        data.minimumHeight = 140;
        data.horizontalSpan = 4;
        table.setLayoutData((Object)data);
        this.bodyEditorComposite = this.getWidgetFactory().createComposite((Composite)this.opaqueExpressionGroup);
        data = new GridData(4, 4, true, true);
        this.bodyEditorComposite.setLayoutData((Object)data);
        this.add = this.getWidgetFactory().createButton((Composite)this.opaqueExpressionGroup, null, 8);
        this.add.setImage(ToolkitPlugin.getDefault().getImageRegistry().get("toolitem.add"));
        data = new GridData(30, -1);
        this.add.setLayoutData((Object)data);
        this.remove = this.getWidgetFactory().createButton((Composite)this.opaqueExpressionGroup, null, 8);
        this.remove.setImage(ToolkitPlugin.getDefault().getImageRegistry().get("toolitem.remove"));
        data = new GridData(30, -1);
        this.remove.setLayoutData((Object)data);
        this.updateRemoveButtonState(this.remove);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object selected = ((IStructuredSelection)OpaqueExpressionSection.this.languagesViewer.getSelection()).getFirstElement();
                if (selected != null) {
                    OpaqueExpressionSection.this.getElements().remove(selected);
                    OpaqueExpressionSection.this.syncToModel();
                    OpaqueExpressionSection.this.updateRemoveButtonState(OpaqueExpressionSection.this.remove);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button down = this.getWidgetFactory().createButton((Composite)this.opaqueExpressionGroup, null, 8);
        down.setImage(CapellaUIPropertiesPlugin.getDefault().getImage("ArrowDown_16x16.gif"));
        data = new GridData(30, -1);
        down.setLayoutData((Object)data);
        final Button up = this.getWidgetFactory().createButton((Composite)this.opaqueExpressionGroup, null, 8);
        up.setImage(CapellaUIPropertiesPlugin.getDefault().getImage("ArrowUp_16x16.gif"));
        data = new GridData(30, -1);
        up.setLayoutData((Object)data);
        SelectionAdapter upDown = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)OpaqueExpressionSection.this.languagesViewer.getSelection();
                OpaqueExpressionElement element = (OpaqueExpressionElement)sel.getFirstElement();
                if (element != null) {
                    WritableList l = (WritableList)OpaqueExpressionSection.this.languagesViewer.getInput();
                    int currentIndex = l.indexOf((Object)element);
                    if (e.getSource() == up) {
                        if (currentIndex > 0) {
                            l.move(currentIndex, currentIndex - 1);
                        }
                    } else if (currentIndex < l.size() - 1) {
                        l.move(currentIndex, currentIndex + 1);
                    }
                    OpaqueExpressionSection.this.syncToModel();
                }
            }
        };
        up.addSelectionListener((SelectionListener)upDown);
        down.addSelectionListener((SelectionListener)upDown);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog i = new InputDialog(e.widget.getDisplay().getActiveShell(), "Add OpaqueExpression element", "Enter language name", null, new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText != null && newText.trim().isEmpty()) {
                            return "";
                        }
                        for (Object o : OpaqueExpressionSection.this.getElements()) {
                            if (newText == null || !((OpaqueExpressionElement)o).getDisplayLanguage().trim().equals(newText.trim())) continue;
                            return "Language is already used";
                        }
                        return null;
                    }
                });
                if (i.open() == 0) {
                    String language = i.getValue().trim();
                    if (language.equals("LinkedText")) {
                        language = "capella:linkedText";
                    }
                    OpaqueExpressionElement oe = new OpaqueExpressionElement(OpaqueExpressionSection.this.getOpaqueExpression(), language, "");
                    oe.addPropertyChangeListener("body", OpaqueExpressionSection.this.bodyListener);
                    OpaqueExpressionSection.this.getElements().add((Object)oe);
                    OpaqueExpressionSection.this.languagesViewer.setSelection((ISelection)new StructuredSelection((Object)oe));
                    OpaqueExpressionSection.this.syncToModel();
                }
                OpaqueExpressionSection.this.updateRemoveButtonState(OpaqueExpressionSection.this.remove);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ViewerSupport.bind((StructuredViewer)this.languagesViewer, (IObservableList)this.elements, (IValueProperty)BeanProperties.value((String)"displayLanguage"));
    }

    protected void updateRemoveButtonState(Button remove) {
        if (this.getElements().size() > 1) {
            remove.setEnabled(true);
        } else {
            remove.setEnabled(false);
        }
    }

    protected void updateTextArea(OpaqueExpressionElement firstElement) {
        Control[] controlArray = this.bodyEditorComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.bodyEditorComposite.setLayout(null);
        if (firstElement != null) {
            LanguageProvider.Registry.INSTANCE.getProviderFor(firstElement.getOpaqueExpression(), firstElement).createControl(this.bodyEditorComposite, this.getWidgetFactory());
        }
        this.bodyEditorComposite.layout(true, true);
    }

    static class DefaultLanguageProvider
    extends LanguageProvider {
        final OpaqueExpressionElement _element;

        public DefaultLanguageProvider(OpaqueExpressionElement element) {
            this._element = element;
        }

        @Override
        public void createControl(Composite parent, TabbedPropertySheetWidgetFactory factory) {
            parent.setLayout((Layout)new FillLayout());
            StyledText text = new StyledText(parent, 2 | factory.getBorderStyle());
            text.setAlwaysShowScrollBars(false);
            text.setText(this._element.getBody() == null ? "" : this._element.getBody());
            final DataBindingContext context = new DataBindingContext();
            DelayedObservableValue widgetValue = new DelayedObservableValue(100, (IObservableValue)WidgetProperties.text((int)24).observe((Widget)text));
            IObservableValue modelValue = BeanProperties.value(OpaqueExpressionElement.class, (String)"body").observe((Object)this._element);
            context.bindValue((IObservableValue)widgetValue, modelValue, new UpdateValueStrategy(), null);
            text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    context.dispose();
                }
            });
        }
    }

    public static abstract class LanguageProvider {
        public abstract void createControl(Composite var1, TabbedPropertySheetWidgetFactory var2);

        static interface Registry {
            public static final Registry INSTANCE = new Registry(){

                @Override
                public LanguageProvider getProviderFor(OpaqueExpression expression, OpaqueExpressionElement element) {
                    LanguageProvider result = null;
                    result = "capella:linkedText".equals(element.getLanguage()) ? new LinkedTextLanguageProvider(expression, element) : new DefaultLanguageProvider(element);
                    return result;
                }
            };

            public LanguageProvider getProviderFor(OpaqueExpression var1, OpaqueExpressionElement var2);
        }
    }

    static class LinkedTextLanguageProvider
    extends LanguageProvider {
        private final OpaqueExpressionElement _element;

        public LinkedTextLanguageProvider(OpaqueExpression expression, OpaqueExpressionElement element) {
            this._element = element;
        }

        @Override
        public void createControl(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
            parent.setLayout((Layout)new FillLayout());
            CapellaEmbeddedLinkedTextEditor editor = new CapellaEmbeddedLinkedTextEditor(parent, 0x300 | widgetFactory.getBorderStyle());
            final CapellaEmbeddedLinkedTextEditorInput input = new CapellaEmbeddedLinkedTextEditorInput((EObject)this._element.getOpaqueExpression()){

                public String getText() {
                    return _element.getBody() == null ? "" : _element.getBody();
                }

                public void setText(String linkedText) {
                    _element.setBody(linkedText);
                }
            };
            editor.getSourceViewer().getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    input.dispose();
                }
            });
            editor.setInput((LinkedTextDocument.Input)input);
        }
    }

    static class OpaqueExpressionElement {
        private final PropertyChangeSupport propertyChangeSupport;
        private final OpaqueExpression opaqueExpr;
        private final String language;
        private String body;

        OpaqueExpressionElement(OpaqueExpression opaqueExpression, String language, String body) {
            this.language = language;
            this.body = body;
            this.propertyChangeSupport = new PropertyChangeSupport(this);
            this.opaqueExpr = opaqueExpression;
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public OpaqueExpression getOpaqueExpression() {
            return this.opaqueExpr;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getDisplayLanguage() {
            int colon = this.getLanguage().indexOf(58);
            return colon == -1 ? this.getLanguage() : StringUtils.capitalize((String)this.getLanguage().substring(colon + 1));
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            if (!Objects.equal((Object)body, (Object)this.body)) {
                this.body = body;
                this.propertyChangeSupport.firePropertyChange("body", this.body, this.body);
            }
        }
    }
}

