/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.interface_;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHKInterfaceExchangeItemAllocationConsistency
extends AbstractValidationRule {
    private Set<IStatus> statuses;

    public IStatus validate(IValidationContext context) {
        this.statuses = new HashSet<IStatus>();
        EObject eObj = context.getTarget();
        if (eObj instanceof Interface) {
            Interface interfaze = (Interface)eObj;
            this.validateInterface(context, interfaze);
            if (!this.statuses.isEmpty()) {
                return ConstraintStatus.createMultiStatus((IValidationContext)context, this.statuses);
            }
        }
        return context.createSuccessStatus();
    }

    private void validateInterface(IValidationContext context, Interface interfaze) {
        Set relatedComponent = (Set)InterfaceExt.getRelatedComponents((Interface)interfaze);
        HashSet relatedComponentsExchangeItems = new HashSet(0);
        block0: for (Component currentComponent : relatedComponent) {
            Set allocatedFunctions = (Set)ComponentExt.getAllocatedFunctions((Component)currentComponent);
            for (AbstractFunction allocatedFunction : allocatedFunctions) {
                boolean isOK;
                Set relatedComponentExchangeItems = (Set)AbstractFunctionExt.getAllExchangeItems((AbstractFunction)allocatedFunction);
                relatedComponentsExchangeItems.addAll(relatedComponentExchangeItems);
                Set interfaceExchangeItems = (Set)InterfaceExt.getAllExchangeItems((Interface)interfaze);
                Collection interfaces = ComponentExt.getRelatedInterfaces((Component)currentComponent);
                boolean bl = isOK = interfaces.contains(interfaze) && relatedComponentExchangeItems.containsAll(interfaceExchangeItems);
                if (isOK) continue;
                String COMPONENT_PREFIX = "\"" + currentComponent.getName() + "\" ( " + currentComponent.eClass().getName() + " ) ";
                String INTARFACE_PREFIX = "\"" + interfaze.getName() + "\" ( " + interfaze.eClass().getName() + " ) ";
                this.statuses.add(this.createFailureStatus(context, new Object[]{INTARFACE_PREFIX, COMPONENT_PREFIX}));
                continue block0;
            }
        }
    }
}

