/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.oa.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.ui.action.ViewerFilterAction;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.polarsys.capella.core.data.capellamodeller.presentation.CapellaModellerEditorPlugin;
import org.polarsys.capella.core.data.oa.presentation.OaEditor;
import org.polarsys.kitalpha.ad.metadata.helpers.LibraryHelper;
import org.polarsys.kitalpha.emde.ui.actions.EmdeViewerFilterAction;
import org.polarsys.kitalpha.emde.ui.i18n.Messages;
import org.polarsys.kitalpha.resourcereuse.emfscheme.helpers.ModelReuseHelper;
import org.polarsys.kitalpha.resourcereuse.emfscheme.utils.services.ResourceSetLoaderServices;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;
import org.polarsys.kitalpha.resourcereuse.ui.dialog.ResourceReuseSelectionDialog;

public class OaActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener,
IPropertyChangeListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new ShowPropertiesViewAction();
    protected IAction refreshViewerAction = new RefreshViewerAction();
    protected IAction schemeLoadResourceAction = new SchemeLoadResourceAction();
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    protected Collection<EmdeViewerFilterAction> currentResourceEmdeViewerFilterActions;
    protected IMenuManager extensionViewerFilterMenuManager;
    protected Resource currentResource;

    public OaActionBarContributor() {
        super(1);
        this.loadResourceAction = new ExtendedLoadResourceAction();
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof ViewerFilterAction && this.selectionProvider.getSelection() != null) {
            this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
        }
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("oa-settings"));
        toolBarManager.add((IContributionItem)new Separator("oa-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(CapellaModellerEditorPlugin.INSTANCE.getString("_UI_OaEditor_menu"), "org.polarsys.capella.core.data.oaMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.extensionViewerFilterMenuManager = new MenuManager(Messages._UI_Model_Extensions);
        submenuManager.insertBefore("additions-end", (IContributionItem)this.extensionViewerFilterMenuManager);
        submenuManager.insertBefore("additions-end", (IContributionItem)new Separator());
        this.createChildMenuManager = new MenuManager(CapellaModellerEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(CapellaModellerEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (!(part instanceof OaEditor) && this.currentResourceEmdeViewerFilterActions != null) {
            for (EmdeViewerFilterAction filterAction : this.currentResourceEmdeViewerFilterActions) {
                filterAction.setEnabled(false);
            }
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.currentResourceEmdeViewerFilterActions != null) {
            this.currentResourceEmdeViewerFilterActions.clear();
            this.currentResourceEmdeViewerFilterActions = null;
        }
        if (this.extensionViewerFilterMenuManager != null) {
            this.extensionViewerFilterMenuManager.dispose();
            this.extensionViewerFilterMenuManager = null;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Object selectedObject = null;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            selectedObject = ((IStructuredSelection)selection).getFirstElement();
        }
        Resource resource = null;
        if (selectedObject instanceof EObject) {
            resource = ((EObject)selectedObject).eResource();
        } else if (selectedObject instanceof Resource) {
            resource = (Resource)selectedObject;
        }
        if (resource != null && !resource.equals(this.currentResource)) {
            if (this.currentResource != null) {
                if (this.extensionViewerFilterMenuManager != null) {
                    this.depopulateManager((IContributionManager)this.extensionViewerFilterMenuManager, this.currentResourceEmdeViewerFilterActions);
                }
                this.currentResourceEmdeViewerFilterActions = null;
            }
            this.currentResource = resource;
        }
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        if (this.currentResourceEmdeViewerFilterActions == null) {
            this.currentResourceEmdeViewerFilterActions = ((OaEditor)this.activeEditorPart).getEmdeViewerFilterActions(this.currentResource);
            if (this.extensionViewerFilterMenuManager != null) {
                this.populateManager((IContributionManager)this.extensionViewerFilterMenuManager, this.currentResourceEmdeViewerFilterActions, null);
                this.extensionViewerFilterMenuManager.update(true);
            }
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        if (selectedObject != null) {
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(selectedObject, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, selectedObject);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(CapellaModellerEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(CapellaModellerEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        MenuManager extensionMenuManager = new MenuManager(Messages._UI_Model_Extensions);
        this.populateManager((IContributionManager)extensionMenuManager, this.currentResourceEmdeViewerFilterActions, null);
        menuManager.insertAfter("additions", (IContributionItem)extensionMenuManager);
        menuManager.insertAfter("additions", (IContributionItem)new Separator());
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        menuManager.insertBefore("additions-end", this.schemeLoadResourceAction);
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public static class ExtendedLoadResourceAction
    extends LoadResourceAction {
        public void run() {
            ExtendedLoadResourceDialog loadResourceDialog = new ExtendedLoadResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domain);
            loadResourceDialog.open();
        }

        public static class ExtendedLoadResourceDialog
        extends LoadResourceAction.LoadResourceDialog {
            public ExtendedLoadResourceDialog(Shell parent, EditingDomain domain) {
                super(parent, domain);
            }

            protected boolean processResource(Resource resource) {
                ResourceSet resourceSet = this.domain.getResourceSet();
                LibraryHelper.add((ResourceSet)resourceSet, (URI)((Resource)resourceSet.getResources().get(0)).getURI(), (URI)resource.getURI());
                return true;
            }
        }

        public static class RegisteredPackageDialog
        extends ElementListSelectionDialog {
            public RegisteredPackageDialog(Shell parent) {
                super(parent, (ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
                    }
                });
                this.setMultipleSelection(true);
                this.setMessage(EcoreEditorPlugin.INSTANCE.getString("_UI_SelectRegisteredPackageURI"));
                this.setFilter("*");
                Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
                Object[] result = ePackageNsURItoGenModelLocationMap.keySet().toArray(new Object[ePackageNsURItoGenModelLocationMap.size()]);
                Arrays.sort(result);
                this.setElements(result);
                this.setTitle(EcoreEditorPlugin.INSTANCE.getString("_UI_PackageSelection_label"));
            }
        }
    }

    private final class RefreshViewerAction
    extends Action {
        private RefreshViewerAction() {
            super(CapellaModellerEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item"));
        }

        public boolean isEnabled() {
            return OaActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (OaActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)OaActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    }

    private final class SchemeLoadResourceAction
    extends Action {
        public SchemeLoadResourceAction() {
            super("Load Reusable Resource...");
            URI uri = URI.createURI((String)"platform:/plugin/org.polarsys.kitalpha.resourcereuse.emfscheme.ui/icons/searchView.gif");
            this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)uri));
        }

        public void run() {
            if (OaActionBarContributor.this.activeEditorPart instanceof IViewerProvider) {
                Viewer viewer = ((IViewerProvider)OaActionBarContributor.this.activeEditorPart).getViewer();
                if (viewer == null) {
                    return;
                }
                ResourceReuseSelectionDialog dialog = new ResourceReuseSelectionDialog(OaActionBarContributor.this.activeEditor.getSite().getShell());
                if (dialog.open() == 0) {
                    EObject selection = (EObject)OaActionBarContributor.this.currentResource.getContents().get(0);
                    SearchCriteria criteria = dialog.getCriteria();
                    URI modelToLoad = ModelReuseHelper.createModelReuseURI((SearchCriteria)criteria);
                    try {
                        Resource res = ResourceSetLoaderServices.loadResourceForCurrentResourceSet((EObject)selection, (URI)modelToLoad);
                        if (res != null) {
                            LibraryHelper.add((ResourceSet)OaActionBarContributor.this.currentResource.getResourceSet(), (URI)OaActionBarContributor.this.currentResource.getURI(), (URI)modelToLoad);
                        }
                    }
                    catch (Exception e) {
                        CapellaModellerEditorPlugin.INSTANCE.log(e);
                    }
                }
            }
        }
    }

    private final class ShowPropertiesViewAction
    extends Action {
        private ShowPropertiesViewAction() {
            super(CapellaModellerEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item"));
        }

        public void run() {
            try {
                OaActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                CapellaModellerEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    }
}

