/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.provider.CommunicationItemProviderAdapterFactory;
import org.polarsys.capella.core.data.information.communication.provider.CommunicationLinkItemProvider;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItemService;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionPreferenceOption;
import org.polarsys.capella.core.ui.toolkit.decomposition.Messages;
import org.polarsys.capella.core.ui.toolkit.viewers.CapellaElementLabelProvider;

public class DecompositionLabelProvider
extends CapellaElementLabelProvider
implements IBaseLabelProvider,
IColorProvider,
IFontProvider {
    private boolean _sourceViewer;
    private Font boldFont = new Font((Device)Display.getCurrent(), "Verdana", 8, 1);
    private Font normalFont = new Font((Device)Display.getCurrent(), "Verdana", 8, 0);
    ImageDescriptor implImageDescriptorFromPlugin = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.ui.toolkit", (String)Messages.getString("LCDecomp.interface.icon.LCInterfaceImpl"));
    Image implImage = this.implImageDescriptorFromPlugin.createImage();
    ImageDescriptor useImageDescriptorFromPlugin = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.ui.toolkit", (String)Messages.getString("LCDecomp.interface.icon.LCInterfaceUse"));
    Image useImage = this.useImageDescriptorFromPlugin.createImage();

    public DecompositionLabelProvider(boolean flag, ImageRegistry imgRegistry) {
        this.setSourceViewer(flag);
    }

    public String getText(Object element) {
        DecompositionItem itemItf;
        if (element instanceof DecompositionComponent) {
            DecompositionComponent comp = (DecompositionComponent)element;
            Object value = comp.getValue();
            if (value != null && value instanceof LogicalComponent) {
                LogicalComponent lc = (LogicalComponent)value;
                String lc_name = lc.getName();
                EList abstractTypedElements = lc.getAbstractTypedElements();
                if (abstractTypedElements.isEmpty()) {
                    return element.toString();
                }
                AbstractTypedElement abstractTypedElement = (AbstractTypedElement)abstractTypedElements.get(0);
                String part_name = abstractTypedElement.getName();
                if (this.getSynchronizationModeSelected()) {
                    if (comp.isComposite()) {
                        if (comp.isTrigger()) {
                            comp.setName(element.toString());
                            return String.valueOf(element.toString()) + " : " + element.toString() + Messages.getString("LCDecomp.component.compositelabel");
                        }
                        return String.valueOf(element.toString()) + Messages.getString("LCDecomp.component.compositelabel");
                    }
                    if (comp.isTrigger()) {
                        comp.setName(element.toString());
                        return String.valueOf(element.toString()) + " : " + element.toString();
                    }
                    return element.toString();
                }
                if (comp.isComposite()) {
                    if (comp.isTrigger()) {
                        comp.setName(element.toString());
                        return String.valueOf(element.toString()) + " : " + lc_name + Messages.getString("LCDecomp.component.compositelabel");
                    }
                    return String.valueOf(part_name) + " : " + element.toString() + Messages.getString("LCDecomp.component.compositelabel");
                }
                if (comp.isTrigger()) {
                    comp.setName(element.toString());
                    return String.valueOf(element.toString()) + " : " + lc_name;
                }
                return element.toString();
            }
            return element.toString();
        }
        if (element instanceof DecompositionItem && (itemItf = (DecompositionItem)element).isInternal()) {
            String label = new String(itemItf.getName());
            label = label.concat(" [Refined]");
            return label;
        }
        return element.toString();
    }

    public boolean isSourceViewer() {
        return this._sourceViewer;
    }

    public void setSourceViewer(boolean sourceViewer) {
        this._sourceViewer = sourceViewer;
    }

    public Image getImage(Object element) {
        if (element instanceof DecompositionComponent) {
            DecompositionComponent dComp = (DecompositionComponent)element;
            Object value = dComp.getValue();
            if (value != null) {
                return super.getImage(value);
            }
            return super.getImage((Object)LaFactory.eINSTANCE.createLogicalComponent());
        }
        if (element instanceof DecompositionItem) {
            DecompositionItem item = (DecompositionItem)element;
            Object value = item.getValue();
            if (value != null) {
                if (value instanceof Interface) {
                    if (item.isInterfaceUsage()) {
                        return this.useImage;
                    }
                } else if (value instanceof CommunicationLink) {
                    CommunicationItemProviderAdapterFactory cipaf = new CommunicationItemProviderAdapterFactory();
                    CommunicationLinkItemProvider clip = new CommunicationLinkItemProvider((AdapterFactory)cipaf);
                    Object image = clip.getImage(value);
                    return ExtendedImageRegistry.getInstance().getImage(image);
                }
            }
            return this.implImage;
        }
        if (element instanceof DecompositionItemService) {
            DecompositionItemService item = (DecompositionItemService)element;
            Object value = item.getValue();
            if (value != null) {
                return super.getImage(value);
            }
            return null;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        Color color = Display.getCurrent().getSystemColor(2);
        int status = -1;
        if (element instanceof DecompositionItem) {
            DecompositionItem item = (DecompositionItem)element;
            if (this.isSourceViewer()) {
                status = item.getStatus();
            } else if (item.getParentComponent().isReusedComponent()) {
                color = Display.getCurrent().getSystemColor(15);
            }
        }
        switch (status) {
            case 3: {
                color = Display.getCurrent().getSystemColor(12);
                break;
            }
            case 1: {
                color = Display.getCurrent().getSystemColor(6);
                break;
            }
            case 2: {
                color = Display.getCurrent().getSystemColor(3);
                break;
            }
        }
        return color;
    }

    public Font getFont(Object element) {
        if (element instanceof DecompositionItem && !this.isSourceViewer() && ((DecompositionItem)element).isAlreadyDecomposed()) {
            return this.boldFont;
        }
        return this.normalFont;
    }

    private boolean getSynchronizationModeSelected() {
        return DecompositionPreferenceOption.synchronizeName;
    }

    public void dispose() {
        super.dispose();
        this.implImage.dispose();
        this.useImage.dispose();
    }
}

