/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ui.toolkit.widgets.MdeFilteredList;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;

public class DecompositionReuseComponentDialog
extends PopupDialog {
    Text _text;
    List<Control> exclusions = new ArrayList<Control>();
    MdeFilteredList filteredList = null;
    List<DecompositionComponent> reusedComponents;

    public DecompositionReuseComponentDialog(Shell parent_p, int shellStyle_p, boolean takeFocusOnOpen_p, boolean persistBounds_p, boolean showDialogMenu_p, boolean showPersistAction_p, String titleText_p, String infoText_p, Text text_p, List<DecompositionComponent> reusedComponents_p) {
        super(parent_p, shellStyle_p, takeFocusOnOpen_p, persistBounds_p, showDialogMenu_p, showPersistAction_p, titleText_p, infoText_p);
        this._text = text_p;
        this.reusedComponents = reusedComponents_p;
    }

    private List<Control> buildExclusionList(Control control) {
        ArrayList<Control> tmp = new ArrayList<Control>();
        if (!this.exclusions.contains(control)) {
            tmp.add(control);
            control.setBackground(Display.getCurrent().getSystemColor(1));
        }
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control cc = controlArray[n2];
                tmp.addAll(this.buildExclusionList(cc));
                ++n2;
            }
        }
        return tmp;
    }

    protected Control createDialogArea(Composite parent_p) {
        this.filteredList = new MdeFilteredList(parent_p, 0x1000000, (ILabelProvider)new LabelProvider(), true, false, true);
        this.filteredList.setFilter(this._text.getText());
        this.filteredList.setElements(this.reusedComponents.toArray());
        this.exclusions.addAll(this.buildExclusionList((Control)this.filteredList));
        this.filteredList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event_p) {
                if (event_p.item != null) {
                    DecompositionReuseComponentDialog.this._text.setText(DecompositionReuseComponentDialog.this.filteredList.getSelection()[0].toString());
                    DecompositionReuseComponentDialog.this._text.setData(DecompositionReuseComponentDialog.this.filteredList.getSelection()[0]);
                    DecompositionReuseComponentDialog.this._text.setFocus();
                    DecompositionReuseComponentDialog.this.close();
                }
            }

            public void widgetSelected(SelectionEvent event_p) {
                Object obj;
                if (event_p.item != null && (obj = DecompositionReuseComponentDialog.this.filteredList.getSelection()[0]) instanceof DecompositionComponent) {
                    DecompositionComponent comp = (DecompositionComponent)obj;
                    DecompositionReuseComponentDialog.this.setInfoText(comp.getPath());
                    DecompositionReuseComponentDialog.this.filteredList.setToolTipText(comp.getPath());
                }
            }
        });
        return this.filteredList;
    }

    public Control createInfoTextArea(Composite parent_p) {
        Label label = (Label)super.createInfoTextArea(parent_p);
        Label lbl = new Label(parent_p, 0x100 | label.getStyle());
        lbl.setFont(label.getFont());
        lbl.setForeground(label.getForeground());
        lbl.setLayoutData(label.getLayoutData());
        lbl.setText(label.getText());
        return lbl;
    }

    protected Control createTitleMenuArea(Composite parent_p) {
        Control ctrl = super.createTitleMenuArea(parent_p);
        this.exclusions.addAll(this.buildExclusionList(ctrl));
        return ctrl;
    }

    protected List getBackgroundColorExclusions() {
        this.exclusions.addAll(super.getBackgroundColorExclusions());
        return this.exclusions;
    }

    protected Point getInitialLocation(Point initialSize_p) {
        Rectangle rect = this._text.getBounds();
        Point tmp = this._text.getLocation();
        Point pt = this._text.toDisplay(rect.x - tmp.x, rect.y - tmp.y);
        return pt;
    }

    public void refreshList(String text_p) {
        this.filteredList.setFilter(text_p);
    }
}

