/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.resolver;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.helpers.interaction.services.MessageEndExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.ScenarioRepresentation;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ResolverException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IResolver;

public class MultipleDecompositionResolver
implements IResolver {
    public Object getName() {
        return "Multiple Decomposition Resolver";
    }

    public List<AbstractInstance> resolving(List<AbstractInstance> candidateAbstractInstances, ScenarioRepresentation srcTree, ScenarioRepresentation tgtTree, AbstractEnd srcMsg, MessageEndExt.COMPONENT_TYPE type) throws ResolverException {
        ArrayList<AbstractInstance> filteredAbstractInstances = new ArrayList<AbstractInstance>();
        ArrayList<AbstractInstance> selectedAbstractInstances = new ArrayList<AbstractInstance>();
        if (candidateAbstractInstances != null && tgtTree != null) {
            for (AbstractInstance part : candidateAbstractInstances) {
                Component cpnt = (Component)part.getAbstractType();
                if (!CapellaElementExt.areInSameDecompositionAlternative((CapellaElement)cpnt, (CapellaElement)tgtTree.getScenario())) continue;
                filteredAbstractInstances.add(part);
            }
        }
        if (filteredAbstractInstances.size() > 0) {
            selectedAbstractInstances.addAll(filteredAbstractInstances);
        } else {
            selectedAbstractInstances.addAll(candidateAbstractInstances);
        }
        return selectedAbstractInstances;
    }
}

