/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.kitalpha.emde.model.Element;

public class ModelAdaptation {
    public static ModelElement adaptToCapella(Object element) {
        if (element instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)element;
            List<ModelElement> adapted = ModelAdaptation.adaptFromStructuredSelection(structuredSelection);
            return adapted.isEmpty() ? null : adapted.get(0);
        }
        return ModelAdaptation.adaptFromObject(element);
    }

    public static List<ModelElement> adaptToCapellaElements(Object element) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        if (element instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)element;
            return ModelAdaptation.adaptFromStructuredSelection(structuredSelection);
        }
        result.add(ModelAdaptation.adaptFromObject(element));
        return result;
    }

    private static ModelElement adaptFromObject(Object element) {
        Object dnodeElement;
        ModelElement result = null;
        if (element instanceof ModelElement) {
            result = (ModelElement)element;
        } else if (element instanceof IAdaptable && (dnodeElement = ((IAdaptable)element).getAdapter(EObject.class)) != null) {
            EObject obj = (EObject)Platform.getAdapterManager().getAdapter(dnodeElement, Element.class);
            if (obj == null) {
                obj = (EObject)Platform.getAdapterManager().loadAdapter(dnodeElement, Element.class.getName());
            }
            if (obj instanceof ModelElement) {
                result = (ModelElement)obj;
            }
        }
        return result;
    }

    private static List<ModelElement> adaptFromStructuredSelection(IStructuredSelection structuredSelection) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>(0);
        for (Object nextSelected : structuredSelection) {
            result.add(ModelAdaptation.adaptFromObject(nextSelected));
        }
        return result;
    }
}

