/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.updateconnections.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.diffmerge.api.IMapping;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.impl.scopes.FilteredModelScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

public class SparseModelScope
extends FilteredModelScope {
    private final ListenerList listeners = new ListenerList();
    private AttachHandler attachHandler = new NullHandler();
    private IMapping mapping;
    private final Collection<EObject> referenceOnlyContent = new HashSet<EObject>();

    public SparseModelScope(Collection<? extends EObject> elements) {
        super(new ArrayList<EObject>(elements));
    }

    public void addListener(Listener l) {
        this.listeners.add((Object)l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove((Object)l);
    }

    public void setAttachHandler(AttachHandler handler) {
        this.attachHandler = handler == null ? new NullHandler() : handler;
    }

    public void setMapping(IMapping mapping) {
        this.mapping = mapping;
    }

    public Collection<EObject> getExternalReferenceElements() {
        return this.referenceOnlyContent;
    }

    public boolean add(EObject element) {
        if (element.eContainer() == null) {
            EObject origin = null;
            Role targetRole = Role.REFERENCE;
            IMatch match = this.mapping.getMatchFor(element, targetRole);
            if (match != null) {
                origin = match.get(Role.TARGET);
            } else {
                targetRole = Role.TARGET;
                match = this.mapping.getMatchFor(element, targetRole);
                origin = match.get(Role.REFERENCE);
            }
            this.attachHandler.attachContainment(element, origin, targetRole, this.mapping);
        }
        boolean result = super.add(element);
        this.fireChange();
        return result;
    }

    private void fireChange() {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((Listener)l[i]).scopeChanged();
            ++i;
        }
    }

    public boolean add(EObject source, EReference reference, EObject value) {
        boolean result = super.add(source, reference, value);
        if (reference.isContainment()) {
            this.fireChange();
        }
        return result;
    }

    public void addAll(Collection<? extends EObject> all) {
        for (EObject eObject : all) {
            this.add(eObject);
        }
    }

    public static interface AttachHandler {
        public void attachContainment(EObject var1, EObject var2, Role var3, IMapping var4);
    }

    static interface Listener {
        public void scopeChanged();
    }

    private static class NullHandler
    implements AttachHandler {
        private NullHandler() {
        }

        @Override
        public void attachContainment(EObject toAttach, EObject source, Role role, IMapping mapping) {
        }
    }
}

