/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.platform.sirius.clipboard.util.LayerUtil;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;

public class ShowInDiagramAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    public ShowInDiagramAction() {
        super(Messages.ShowInDiagramAction_Title);
        this.setActionDefinitionId("org.polarsys.capella.core.platform.sirius.ui.navigator.showInDiagramCommand");
    }

    public void run() {
        Object selectedElement = this.getStructuredSelection().getFirstElement();
        EObject adaptedElement = CapellaAdapterHelper.resolveSemanticObject((Object)selectedElement, (boolean)true);
        Object object = selectedElement = adaptedElement == null ? selectedElement : adaptedElement;
        if (!CapellaResourceHelper.isSemanticElement((Object)selectedElement)) {
            return;
        }
        DSemanticDecorator view = null;
        boolean allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)((EObject)selectedElement)));
        if (!allowMultiplePart && selectedElement instanceof Component) {
            for (Part part : ComponentExt.getRepresentingParts((Component)((Component)selectedElement))) {
                view = this.getPreferedView((EObject)part);
                if (view != null) break;
            }
        }
        if (view == null) {
            view = this.getPreferedView((EObject)selectedElement);
        }
        if (view == null) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ShowInDiagramAction_UnknownElement_Title, (String)Messages.ShowInDiagramAction_UnknownElement_Message);
        } else if (view instanceof DDiagramElement) {
            DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)view);
            if (query.isFolded()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ShowInDiagramAction_UnknownElement_Title, (String)Messages.ShowInDiagramAction_FoldedElement_Message);
            } else if (query.isHidden()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ShowInDiagramAction_UnknownElement_Title, (String)Messages.ShowInDiagramAction_HiddenElement_Message);
            } else if (query.isCollapsed()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ShowInDiagramAction_UnknownElement_Title, (String)Messages.ShowInDiagramAction_CollapseElement_Message);
            } else if (query.isFiltered()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ShowInDiagramAction_UnknownElement_Title, (String)Messages.ShowInDiagramAction_FilteredElement_Message);
            } else {
                IGraphicalEditPart selectedPart = LayerUtil.getGraphicalPart((DSemanticDecorator)view);
                if (selectedPart == null) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ShowInDiagramAction_UnknownElement_Title, (String)Messages.ShowInDiagramAction_UnknownElement_Message);
                } else {
                    this.selectPart(selectedPart);
                }
            }
        } else if (view instanceof DDiagram) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ShowInDiagramAction_UnknownElement_Title, (String)Messages.ShowInDiagramAction_UnknownElement_Message);
        }
    }

    protected DSemanticDecorator getPreferedView(EObject semantic) {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor != null && activeEditor instanceof SiriusDiagramEditor) {
            SiriusDiagramEditor diagramEditor = (SiriusDiagramEditor)activeEditor;
            DRepresentation diagram = (DRepresentation)diagramEditor.getDiagram().getElement();
            Collection views = DiagramServices.getDiagramServices().getDiagramElements(diagram, semantic);
            if (views.size() == 1) {
                return (DSemanticDecorator)views.iterator().next();
            }
            for (DSemanticDecorator view : views) {
                if (!(view instanceof AbstractDNode)) continue;
                return view;
            }
            for (DSemanticDecorator view : views) {
                if (!(view instanceof DEdge)) continue;
                return view;
            }
        }
        return null;
    }

    protected void selectPart(IGraphicalEditPart part) {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SiriusDiagramEditor diagramEditor = (SiriusDiagramEditor)activeEditor;
        IDiagramGraphicalViewer diagramGraphicalViewer = diagramEditor.getDiagramGraphicalViewer();
        if (part != null) {
            diagramGraphicalViewer.select((EditPart)part);
            diagramGraphicalViewer.reveal((EditPart)part);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result = false;
        if (!selection.isEmpty()) {
            result = CapellaResourceHelper.isSemanticElements((Collection)selection.toList());
        }
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return result &= activeEditor instanceof SiriusDiagramEditor;
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectionChanged((IStructuredSelection)selection);
    }
}

