/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.processor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;

public abstract class UpdateRealizationContributionProcessor
implements IProcessor {
    protected Kind kind = Kind.UNDEFINED;
    protected NamedElement context = null;
    protected NamedElement target = null;

    public UpdateRealizationContributionProcessor(Kind kind) {
        this.kind = kind;
    }

    public UpdateRealizationContributionProcessor(Kind kind, NamedElement context) {
        this.kind = kind;
        this.context = context;
    }

    public Object getResult() {
        return null;
    }

    public void setContext(List<ModelElement> context) {
        if (context != null && context.size() > 0) {
            this.setContext(context.get(0));
        }
    }

    public void setContext(ModelElement context) {
        if (context instanceof NamedElement) {
            context = (NamedElement)context;
        }
    }

    public void setTarget(NamedElement target) {
        this.target = target;
    }

    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        if (this.context instanceof LogicalArchitecture) {
            this.update((BlockArchitecture)((LogicalArchitecture)this.context));
        } else if (this.context instanceof LogicalComponent) {
            this.update((LogicalComponent)this.context);
        } else if (this.context instanceof PhysicalArchitecture) {
            this.update((BlockArchitecture)((PhysicalArchitecture)this.context));
        } else if (this.context instanceof PhysicalComponent) {
            this.update((PhysicalComponent)this.context);
        } else if (this.context instanceof Capability) {
            this.update((Capability)this.context);
        } else if (this.context instanceof CapabilityPkg) {
            this.update((CapabilityPkg)this.context);
        } else if (this.context instanceof CapabilityRealization) {
            this.update((CapabilityRealization)this.context);
        } else if (this.context instanceof CapabilityRealizationPkg) {
            this.update((CapabilityRealizationPkg)this.context);
        } else if (this.context instanceof Scenario) {
            this.update((Scenario)this.context);
        } else {
            throw new ProcessorException("Invalid context type.", (IProcessor)this);
        }
    }

    private void update(BlockArchitecture currentElt) {
        if (currentElt != null) {
            this.update(currentElt.getOwnedAbstractCapabilityPkg());
        }
    }

    private void update(LogicalComponent currentElt) {
        if (currentElt != null) {
            this.update(currentElt.getOwnedAbstractCapabilityPkg());
        }
    }

    private void update(PhysicalComponent currentElt) {
        if (currentElt != null) {
            this.update(currentElt.getOwnedAbstractCapabilityPkg());
        }
    }

    private void update(AbstractCapabilityPkg currentElt) {
        if (currentElt != null) {
            if (currentElt instanceof CapabilityPkg) {
                this.update((CapabilityPkg)currentElt);
            } else if (currentElt instanceof CapabilityRealizationPkg) {
                this.update((CapabilityRealizationPkg)currentElt);
            }
        }
    }

    private void update(Capability currentElt) {
        if (currentElt != null) {
            this.updateInvolvements((AbstractCapability)currentElt, LaPackage.Literals.LOGICAL_ARCHITECTURE);
        }
    }

    private void update(CapabilityPkg currentElt) {
        if (currentElt != null) {
            for (Capability capability : currentElt.getOwnedCapabilities()) {
                this.update(capability);
            }
            for (CapabilityPkg capabilityPkg : currentElt.getOwnedCapabilityPkgs()) {
                this.update(capabilityPkg);
            }
        }
    }

    private void update(CapabilityRealization currentElt) {
        if (currentElt != null) {
            if (this.kind == Kind.STATIC) {
                if (EcoreUtil2.isContainedBy((EObject)currentElt, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE)) {
                    this.updateInvolvements((AbstractCapability)currentElt, PaPackage.Literals.PHYSICAL_ARCHITECTURE);
                } else if (EcoreUtil2.isContainedBy((EObject)currentElt, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE)) {
                    this.updateInvolvements((AbstractCapability)currentElt, EpbsPackage.Literals.EPBS_ARCHITECTURE);
                }
            } else if (this.kind == Kind.DYNAMIC) {
                if (this.target instanceof LogicalArchitecture || EcoreUtil2.isContainedBy((EObject)this.target, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE)) {
                    if (EcoreUtil2.isContainedBy((EObject)currentElt, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE)) {
                        this.updateInvolvements((AbstractCapability)currentElt, LaPackage.Literals.LOGICAL_ARCHITECTURE);
                    }
                } else if (this.target instanceof PhysicalArchitecture || EcoreUtil2.isContainedBy((EObject)this.target, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE)) {
                    if (EcoreUtil2.isContainedBy((EObject)currentElt, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE) || EcoreUtil2.isContainedBy((EObject)currentElt, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE)) {
                        this.updateInvolvements((AbstractCapability)currentElt, PaPackage.Literals.PHYSICAL_ARCHITECTURE);
                    }
                } else if ((this.target instanceof EPBSArchitecture || EcoreUtil2.isContainedBy((EObject)this.target, (EClass)EpbsPackage.Literals.EPBS_ARCHITECTURE)) && EcoreUtil2.isContainedBy((EObject)currentElt, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE)) {
                    this.updateInvolvements((AbstractCapability)currentElt, EpbsPackage.Literals.EPBS_ARCHITECTURE);
                }
            }
        }
    }

    private void update(CapabilityRealizationPkg currentElt) {
        if (currentElt != null) {
            for (CapabilityRealization capability : currentElt.getOwnedCapabilityRealizations()) {
                this.update(capability);
            }
            for (CapabilityRealizationPkg capabilityPkg : currentElt.getOwnedCapabilityRealizationPkgs()) {
                this.update(capabilityPkg);
            }
        }
    }

    private void update(Scenario currentElt) {
        if (currentElt != null) {
            AbstractCapability useCase = ScenarioExt.getRelatedCapability((Scenario)currentElt);
            if (useCase instanceof Capability) {
                this.update((Capability)useCase);
            } else if (useCase instanceof CapabilityRealization) {
                this.update((CapabilityRealization)useCase);
            }
        }
    }

    protected abstract void updateInvolvements(AbstractCapability var1, EClass var2);

    protected static enum Kind {
        UNDEFINED,
        STATIC,
        DYNAMIC;

    }
}

