/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.extendedqueries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Unit;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.queries.filters.RemoveUnnamedElementFilter;
import org.polarsys.capella.core.queries.helpers.QueryExt;

public class GetAvailable_NumericValue_Unit__Lib
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        NumericValue numericValue = (NumericValue)input;
        Unit unit = numericValue.getUnit();
        ArrayList<Object> result = new ArrayList();
        BlockArchitecture blockArchitectureInProject = BlockArchitectureExt.getRootBlockArchitecture((EObject)numericValue);
        IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)numericValue);
        for (IModel library : LibraryManagerExt.getAllActivesReferences((IModel)currentProject)) {
            BlockArchitecture blockArchitecture = QueryExt.getCorrespondingBlockArchitectureFromLibrary((BlockArchitecture)blockArchitectureInProject, (CapellaModel)((CapellaModel)library));
            for (BlockArchitecture currentBlockArchitecture : BlockArchitectureExt.getAllAllocatedArchitectures((BlockArchitecture)blockArchitecture)) {
                DataPkg dataPkg = currentBlockArchitecture.getOwnedDataPkg();
                if (dataPkg == null) continue;
                result.addAll(this.getElementsFromBlockArchitecture(currentBlockArchitecture, unit));
            }
        }
        result = QueryInterpretor.executeFilter(result, (IQueryFilter)new RemoveUnnamedElementFilter());
        return result;
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, Unit link) {
        DataPkg dataPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (arch != null && (dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture((BlockArchitecture)arch)) != null) {
            for (Unit unit : DataPkgExt.getAllUnits((DataPkg)dataPkg)) {
                if (unit.equals(link)) continue;
                availableElements.add((CapellaElement)unit);
            }
        }
        return availableElements;
    }
}

