/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.ArchitectureAllocation;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.StructureHelper;

public class BlockArchitectureHelper {
    private static BlockArchitectureHelper instance;

    private BlockArchitectureHelper() {
    }

    public static BlockArchitectureHelper getInstance() {
        if (instance == null) {
            instance = new BlockArchitectureHelper();
        }
        return instance;
    }

    public Object doSwitch(BlockArchitecture element, EStructuralFeature feature) {
        List<ArchitectureAllocation> ret = null;
        if (feature.equals(CsPackage.Literals.BLOCK_ARCHITECTURE__ALLOCATED_ARCHITECTURES)) {
            ret = this.getAllocatedArchitectures(element);
        } else if (feature.equals(CsPackage.Literals.BLOCK_ARCHITECTURE__ALLOCATING_ARCHITECTURES)) {
            ret = this.getAllocatingArchitectures(element);
        } else if (feature.equals(CsPackage.Literals.BLOCK_ARCHITECTURE__PROVISIONED_ARCHITECTURE_ALLOCATIONS)) {
            ret = this.getProvisionedArchitectureAllocations(element);
        } else if (feature.equals(CsPackage.Literals.BLOCK_ARCHITECTURE__PROVISIONING_ARCHITECTURE_ALLOCATIONS)) {
            ret = this.getProvisioningArchitectureAllocations(element);
        }
        if (ret == null) {
            ret = StructureHelper.getInstance().doSwitch((Structure)element, feature);
        }
        return ret;
    }

    protected List<ArchitectureAllocation> getProvisionedArchitectureAllocations(BlockArchitecture element) {
        EList traces = element.getOutgoingTraces();
        ArrayList<ArchitectureAllocation> ret = new ArrayList<ArchitectureAllocation>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof ArchitectureAllocation)) continue;
            ret.add((ArchitectureAllocation)trace);
        }
        return ret;
    }

    protected List<ArchitectureAllocation> getProvisioningArchitectureAllocations(BlockArchitecture element) {
        EList traces = element.getIncomingTraces();
        ArrayList<ArchitectureAllocation> ret = new ArrayList<ArchitectureAllocation>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof ArchitectureAllocation)) continue;
            ret.add((ArchitectureAllocation)trace);
        }
        return ret;
    }

    protected List<BlockArchitecture> getAllocatedArchitectures(BlockArchitecture element) {
        EList allocs = element.getProvisionedArchitectureAllocations();
        ArrayList<BlockArchitecture> ret = new ArrayList<BlockArchitecture>();
        for (ArchitectureAllocation architectureAllocation : allocs) {
            ret.add(architectureAllocation.getAllocatedArchitecture());
        }
        return ret;
    }

    protected List<BlockArchitecture> getAllocatingArchitectures(BlockArchitecture element) {
        EList allocs = element.getProvisioningArchitectureAllocations();
        ArrayList<BlockArchitecture> ret = new ArrayList<BlockArchitecture>();
        for (ArchitectureAllocation architectureAllocation : allocs) {
            ret.add(architectureAllocation.getAllocatingArchitecture());
        }
        return ret;
    }
}

