/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.AbstractPhysicalArtifact;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkRealization;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocator;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractPathInvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractPhysicalArtifactHelper;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.helpers.fa.delegates.ComponentExchangeAllocatorHelper;
import org.polarsys.capella.core.data.information.Port;

public class PhysicalLinkHelper {
    private static PhysicalLinkHelper instance;

    private PhysicalLinkHelper() {
    }

    public static PhysicalLinkHelper getInstance() {
        if (instance == null) {
            instance = new PhysicalLinkHelper();
        }
        return instance;
    }

    public Object doSwitch(PhysicalLink element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CsPackage.Literals.PHYSICAL_LINK__SOURCE_PHYSICAL_PORT)) {
            ret = this.getSourcePhysicalPort(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_LINK__TARGET_PHYSICAL_PORT)) {
            ret = this.getTargetPhysicalPort(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_LINK__REALIZED_PHYSICAL_LINKS)) {
            ret = this.getRealizedPhysicalLinks(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_LINK__REALIZING_PHYSICAL_LINKS)) {
            ret = this.getRealizingPhysicalLinks(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_LINK__CATEGORIES)) {
            ret = this.getCategories(element);
        }
        if (ret == null) {
            ret = AbstractPathInvolvedElementHelper.getInstance().doSwitch((AbstractPathInvolvedElement)element, feature);
        }
        if (ret == null) {
            ret = AbstractPhysicalArtifactHelper.getInstance().doSwitch((AbstractPhysicalArtifact)element, feature);
        }
        if (ret == null) {
            ret = ComponentExchangeAllocatorHelper.getInstance().doSwitch((ComponentExchangeAllocator)element, feature);
        }
        return ret;
    }

    protected List<EObject> getCategories(PhysicalLink element) {
        return EObjectExt.getReferencers((EObject)element, (EReference)CsPackage.Literals.PHYSICAL_LINK_CATEGORY__LINKS);
    }

    protected PhysicalPort getSourcePhysicalPort(PhysicalLink element) {
        Port port = PhysicalLinkExt.getSourcePort(element);
        if (port instanceof PhysicalPort) {
            return (PhysicalPort)port;
        }
        return null;
    }

    protected PhysicalPort getTargetPhysicalPort(PhysicalLink element) {
        Port port = PhysicalLinkExt.getTargetPort(element);
        if (port instanceof PhysicalPort) {
            return (PhysicalPort)port;
        }
        return null;
    }

    protected List<PhysicalLink> getRealizedPhysicalLinks(PhysicalLink element) {
        ArrayList<PhysicalLink> links = new ArrayList<PhysicalLink>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement link;
            if (!(trace instanceof PhysicalLinkRealization) || !((link = ((PhysicalLinkRealization)trace).getTargetElement()) instanceof PhysicalLink)) continue;
            links.add((PhysicalLink)link);
        }
        return links;
    }

    protected List<PhysicalLink> getRealizingPhysicalLinks(PhysicalLink element) {
        ArrayList<PhysicalLink> links = new ArrayList<PhysicalLink>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement link;
            if (!(trace instanceof PhysicalLinkRealization) || !((link = ((PhysicalLinkRealization)trace).getSourceElement()) instanceof PhysicalLink)) continue;
            links.add((PhysicalLink)link);
        }
        return links;
    }
}

