/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.delegates;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.helpers.modellingcore.delegates.InformationsExchangerHelper;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.helpers.information.delegates.PartitionHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.PortHelper;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.information.PortRealization;

public class ComponentPortHelper {
    private static ComponentPortHelper instance;

    private ComponentPortHelper() {
    }

    public static ComponentPortHelper getInstance() {
        if (instance == null) {
            instance = new ComponentPortHelper();
        }
        return instance;
    }

    public Object doSwitch(ComponentPort element, EStructuralFeature feature) {
        List<ComponentPort> ret = null;
        if (feature.equals(FaPackage.Literals.COMPONENT_PORT__COMPONENT_EXCHANGES)) {
            ret = this.getComponentExchanges(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_PORT__ALLOCATED_FUNCTION_PORTS)) {
            ret = this.getAllocatedFunctionPorts(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_PORT__DELEGATED_COMPONENT_PORTS)) {
            ret = this.getDelegatedComponentPorts(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_PORT__DELEGATING_COMPONENT_PORTS)) {
            ret = this.getDelegatingComponentPorts(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_PORT__ALLOCATING_PHYSICAL_PORTS)) {
            ret = this.getAllocatingPhysicalPorts(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_PORT__REALIZED_COMPONENT_PORTS)) {
            ret = this.getRealizedComponentPorts(element);
        } else if (feature.equals(FaPackage.Literals.COMPONENT_PORT__REALIZING_COMPONENT_PORTS)) {
            ret = this.getRealizingComponentPorts(element);
        }
        if (ret == null) {
            ret = PortHelper.getInstance().doSwitch((Port)element, feature);
        }
        if (ret == null) {
            ret = InformationsExchangerHelper.getInstance().doSwitch((InformationsExchanger)element, feature);
        }
        if (ret == null) {
            ret = PartitionHelper.getInstance().doSwitch((Partition)element, feature);
        }
        return ret;
    }

    protected List<ComponentExchange> getComponentExchanges(ComponentPort element) {
        LinkedHashSet<ComponentExchange> ret = new LinkedHashSet<ComponentExchange>();
        for (AbstractInformationFlow trace : element.getInformationFlows()) {
            if (!(trace instanceof ComponentExchange)) continue;
            ret.add((ComponentExchange)trace);
        }
        for (ComponentExchangeEnd end : FunctionalExt.getRelatedComponentExchangeEnds((Port)element)) {
            EObject owner = end.eContainer();
            if (!(owner instanceof ComponentExchange)) continue;
            ret.add((ComponentExchange)owner);
        }
        return new ArrayList<ComponentExchange>(ret);
    }

    protected List<FunctionPort> getAllocatedFunctionPorts(ComponentPort element) {
        ArrayList<FunctionPort> ret = new ArrayList<FunctionPort>();
        for (PortAllocation portAllocation : element.getOutgoingPortAllocations()) {
            Port port = portAllocation.getAllocatedPort();
            if (!(port instanceof FunctionPort)) continue;
            ret.add((FunctionPort)port);
        }
        return ret;
    }

    protected List<ComponentPort> getDelegatedComponentPorts(ComponentPort element) {
        ArrayList<ComponentPort> ret = new ArrayList<ComponentPort>();
        for (AbstractInformationFlow informationFlow : element.getOutgoingInformationFlows()) {
            InformationsExchanger informationsExchanger;
            if (!(informationFlow instanceof ComponentExchange) || !ComponentExchangeKind.DELEGATION.equals((Object)((ComponentExchange)informationFlow).getKind()) || !((informationsExchanger = informationFlow.getTarget()) instanceof ComponentPort)) continue;
            ret.add((ComponentPort)informationsExchanger);
        }
        return ret;
    }

    protected List<ComponentPort> getDelegatingComponentPorts(ComponentPort element) {
        ArrayList<ComponentPort> ret = new ArrayList<ComponentPort>();
        for (AbstractInformationFlow informationFlow : element.getIncomingInformationFlows()) {
            InformationsExchanger informationsExchanger;
            if (!(informationFlow instanceof ComponentExchange) || !ComponentExchangeKind.DELEGATION.equals((Object)((ComponentExchange)informationFlow).getKind()) || !((informationsExchanger = informationFlow.getSource()) instanceof ComponentPort)) continue;
            ret.add((ComponentPort)informationsExchanger);
        }
        return ret;
    }

    protected List<PhysicalPort> getAllocatingPhysicalPorts(ComponentPort element) {
        ArrayList<PhysicalPort> result = new ArrayList<PhysicalPort>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            Port port;
            if (!(trace instanceof ComponentPortAllocation) || !((port = ((ComponentPortAllocation)trace).getAllocatingPort()) instanceof PhysicalPort)) continue;
            result.add((PhysicalPort)port);
        }
        return result;
    }

    protected List<ComponentPort> getRealizedComponentPorts(ComponentPort element) {
        ArrayList<ComponentPort> result = new ArrayList<ComponentPort>();
        for (PortRealization portAllocation : element.getOutgoingPortRealizations()) {
            Port port = portAllocation.getRealizedPort();
            if (!(port instanceof ComponentPort) || result.contains(port)) continue;
            result.add((ComponentPort)port);
        }
        return result;
    }

    protected List<ComponentPort> getRealizingComponentPorts(ComponentPort element) {
        ArrayList<ComponentPort> result = new ArrayList<ComponentPort>();
        for (PortRealization portAllocation : element.getIncomingPortRealizations()) {
            Port port = portAllocation.getRealizingPort();
            if (!(port instanceof ComponentPort) || result.contains(port)) continue;
            result.add((ComponentPort)port);
        }
        return result;
    }
}

